/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.phpunit.xml.FileNode;
import org.sonar.plugins.php.phpunit.xml.LineNode;
import org.sonar.plugins.php.phpunit.xml.MetricsNode;
import org.sonar.plugins.php.phpunit.xml.PackageNode;
import org.sonar.plugins.php.phpunit.xml.ProjectNode;

public class PhpUnitCoverageResultParser
implements BatchExtension {
    private static final Map<Resource<?>, Measure> MEASURES_BY_RESOURCE = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitCoverageResultParser.class);
    private final Project project;
    private final SensorContext context;
    private final ModuleFileSystem fileSystem;

    public PhpUnitCoverageResultParser(Project project, SensorContext context, ModuleFileSystem fileSystem) {
        this.project = project;
        this.context = context;
        this.fileSystem = fileSystem;
    }

    public void parse(File coverageReportFile) {
        LOG.debug("Parsing file: " + coverageReportFile.getAbsolutePath());
        this.parseFile(coverageReportFile);
    }

    private void parseFile(File coverageReportFile) {
        CoverageNode coverage = this.getCoverage(coverageReportFile);
        List<ProjectNode> projects = coverage.getProjects();
        if (projects != null && !projects.isEmpty()) {
            ProjectNode projectNode = projects.get(0);
            LOG.info("Project: " + projectNode.getName());
            this.parseFileNodes(projectNode.getFiles());
            this.parsePackagesNodes(projectNode.getPackages());
            this.saveMeasureForMissingFiles();
        }
    }

    private void saveMeasureForMissingFiles() {
        for (File phpFile : this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"php"}))) {
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)phpFile, (Project)this.project);
            if (resource == null || this.context.getMeasure((Resource)resource, CoreMetrics.LINE_COVERAGE) != null) continue;
            LOG.debug("Coverage metrics have not been set on '{}': default values will be inserted.", (Object)phpFile.getName());
            this.context.saveMeasure((Resource)resource, CoreMetrics.LINE_COVERAGE, Double.valueOf(0.0));
            Measure ncloc = this.context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
            if (ncloc != null && this.context.getMeasure(CoreMetrics.LINES_TO_COVER) == null) {
                this.context.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, ncloc.getValue());
            }
            if (ncloc == null || this.context.getMeasure(CoreMetrics.UNCOVERED_LINES) != null) continue;
            this.context.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, ncloc.getValue());
        }
    }

    private void parsePackagesNodes(List<PackageNode> packages) {
        if (packages != null) {
            for (PackageNode packageNode : packages) {
                this.parseFileNodes(packageNode.getFiles());
            }
        }
    }

    private void parseFileNodes(List<FileNode> fileNodes) {
        if (fileNodes != null) {
            for (FileNode file : fileNodes) {
                this.saveCoverageMeasure(file);
            }
        }
    }

    protected void saveCoverageMeasure(FileNode fileNode) {
        org.sonar.api.resources.File phpFile = org.sonar.api.resources.File.fromIOFile((File)new File(fileNode.getName()), (Project)this.project);
        if (phpFile != null) {
            PropertiesBuilder lineHits = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
            if (fileNode.getLines() != null) {
                for (LineNode line : fileNode.getLines()) {
                    this.saveLineMeasure(line, (PropertiesBuilder<Integer, Integer>)lineHits);
                }
            }
            MetricsNode metrics = fileNode.getMetrics();
            Measure measure = lineHits.build();
            this.logMeasureByResource((Resource)phpFile, measure);
            this.context.saveMeasure((Resource)phpFile, measure);
            double totalStatementsCount = metrics.getTotalStatementsCount();
            double uncoveredLines = totalStatementsCount - metrics.getCoveredStatements();
            double lineCoverage = 0.0;
            if (metrics.getCoveredStatements() != 0.0) {
                lineCoverage = metrics.getCoveredStatements() / totalStatementsCount;
            }
            this.context.saveMeasure((Resource)phpFile, CoreMetrics.LINES_TO_COVER, Double.valueOf(totalStatementsCount));
            this.context.saveMeasure((Resource)phpFile, CoreMetrics.UNCOVERED_LINES, Double.valueOf(uncoveredLines));
            this.context.saveMeasure((Resource)phpFile, CoreMetrics.LINE_COVERAGE, Double.valueOf(ParsingUtils.scaleValue((double)(lineCoverage * 100.0))));
        }
    }

    private void logMeasureByResource(Resource resource, Measure measure) {
        if (LOG.isDebugEnabled()) {
            Measure alreadySaved = MEASURES_BY_RESOURCE.get(resource);
            if (alreadySaved == null) {
                MEASURES_BY_RESOURCE.put(resource, measure);
            } else {
                LOG.debug("Measure {} already saved for resoruce {}", (Object)measure, (Object)resource);
            }
        }
    }

    private void saveLineMeasure(LineNode line, PropertiesBuilder<Integer, Integer> lineHits) {
        lineHits.add((Object)line.getNum(), (Object)line.getCount());
    }

    private CoverageNode getCoverage(File coverageReportFile) {
        CoverageNode coverageNode;
        FileInputStream inputStream = null;
        try {
            XStream xstream = new XStream();
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.aliasSystemAttribute("classType", "class");
            xstream.processAnnotations(CoverageNode.class);
            xstream.processAnnotations(ProjectNode.class);
            xstream.processAnnotations(FileNode.class);
            xstream.processAnnotations(MetricsNode.class);
            xstream.processAnnotations(LineNode.class);
            inputStream = new FileInputStream(coverageReportFile);
            coverageNode = (CoverageNode)xstream.fromXML((InputStream)inputStream);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Can't read phpUnit report: " + coverageReportFile.getName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return coverageNode;
    }
}

