/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.phpunit.PhpTestSuiteReader;
import org.sonar.plugins.php.phpunit.PhpUnitTestReport;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;
import org.sonar.plugins.php.phpunit.xml.TestSuites;

public class PhpUnitResultParser
implements BatchExtension {
    private static final double PERCENT = 100.0;
    private static final double MILLISECONDS = 1000.0;
    private static final int PRECISION = 1;
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitResultParser.class);
    private SensorContext context;
    private Project project;
    private ModuleFileSystem moduleFileSystem;

    public PhpUnitResultParser(Project project, SensorContext context, ModuleFileSystem moduleFileSystem) {
        this.project = project;
        this.context = context;
        this.moduleFileSystem = moduleFileSystem;
    }

    protected TestSuites getTestSuites(File report) {
        TestSuites testSuites;
        FileInputStream inputStream = null;
        try {
            XStream xstream = new XStream();
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.aliasSystemAttribute("fileName", "class");
            xstream.processAnnotations(TestSuites.class);
            xstream.processAnnotations(TestSuite.class);
            xstream.processAnnotations(TestCase.class);
            inputStream = new FileInputStream(report);
            TestSuites testSuites2 = (TestSuites)xstream.fromXML((InputStream)inputStream);
            LOG.debug("Tests suites: " + testSuites2);
            testSuites = testSuites2;
        }
        catch (IOException e) {
            try {
                throw new SonarException("Can't read PhpUnit report : " + report.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return testSuites;
    }

    private Resource getUnitTestResource(PhpUnitTestReport report) {
        return this.getUnitTestResource(report.getFile());
    }

    @VisibleForTesting
    Resource getUnitTestResource(String filename) {
        File testFile = new File(filename);
        org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)testFile, (Project)this.project);
        if (resource == null) {
            resource = org.sonar.api.resources.File.fromIOFile((File)testFile, (List)this.moduleFileSystem.testDirs());
        }
        return resource;
    }

    private void insertZeroWhenNoReports() {
        this.context.saveMeasure(CoreMetrics.TESTS, Double.valueOf(0.0));
    }

    protected void parse(File reportFile) {
        if (reportFile == null) {
            this.insertZeroWhenNoReports();
        } else {
            LOG.debug("Parsing file: " + reportFile.getAbsolutePath());
            this.parseFile(reportFile);
        }
    }

    private void parseFile(File report) {
        TestSuites testSuites = this.getTestSuites(report);
        List<PhpUnitTestReport> fileReports = this.readSuites(testSuites);
        for (PhpUnitTestReport fileReport : fileReports) {
            this.saveTestReportMeasures(fileReport);
        }
    }

    private List<PhpUnitTestReport> readSuites(TestSuites testSuites) {
        ArrayList<PhpUnitTestReport> result = new ArrayList<PhpUnitTestReport>();
        for (TestSuite testSuite : testSuites.getTestSuites()) {
            PhpTestSuiteReader reader = new PhpTestSuiteReader();
            reader.readSuite(testSuite, null);
            result.addAll(reader.getReportsPerClass());
        }
        return result;
    }

    protected void saveTestReportMeasures(PhpUnitTestReport fileReport) {
        if (!fileReport.isValid()) {
            return;
        }
        Resource unitTestResource = this.getUnitTestResource(fileReport);
        if (unitTestResource != null) {
            double testsCount = fileReport.getTests() - fileReport.getSkipped();
            if (fileReport.getSkipped() > 0) {
                this.context.saveMeasure(unitTestResource, CoreMetrics.SKIPPED_TESTS, Double.valueOf(fileReport.getSkipped()));
            }
            double duration = Math.round(fileReport.getTime() * 1000.0);
            this.context.saveMeasure(unitTestResource, CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(duration));
            this.context.saveMeasure(unitTestResource, CoreMetrics.TESTS, Double.valueOf(testsCount));
            this.context.saveMeasure(unitTestResource, CoreMetrics.TEST_ERRORS, Double.valueOf(fileReport.getErrors()));
            this.context.saveMeasure(unitTestResource, CoreMetrics.TEST_FAILURES, Double.valueOf(fileReport.getFailures()));
            if (testsCount > 0.0) {
                double passedTests = testsCount - (double)fileReport.getErrors() - (double)fileReport.getFailures();
                double percentage = passedTests * 100.0 / testsCount;
                this.context.saveMeasure(unitTestResource, CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)percentage)));
            }
            this.saveTestsDetails(fileReport);
        } else {
            LOG.debug("Following file is not located in the test folder specified in the Sonar configuration: " + fileReport.getFile() + ". The test results won't be reported in Sonar.");
        }
    }

    private void saveTestsDetails(PhpUnitTestReport fileReport) {
        StringBuilder details = new StringBuilder();
        details.append("<tests-details>");
        for (TestCase detail : fileReport.getDetails()) {
            double time = ParsingUtils.scaleValue((double)(detail.getTime() * 1000.0), (int)1);
            details.append("<testcase status=\"").append(detail.getStatus()).append("\" time=\"");
            details.append(time).append("\" name=\"").append(detail.getName().replaceAll(" ", "_")).append("\"");
            boolean isError = "error".equals(detail.getStatus());
            if (isError || "failure".equals(detail.getStatus())) {
                details.append(">").append(isError ? "<error message=\"" : "<failure message=\"");
                details.append(StringEscapeUtils.escapeXml((String)detail.getErrorMessage())).append("\"><![CDATA[");
                details.append(StringEscapeUtils.escapeXml((String)detail.getStackTrace())).append("]]>");
                details.append(isError ? "</error>" : "</failure>").append("</testcase>");
                continue;
            }
            details.append("/>");
        }
        details.append("</tests-details>");
        Resource unitTestResource = this.getUnitTestResource(fileReport);
        if (unitTestResource != null) {
            this.context.saveMeasure(unitTestResource, new Measure(CoreMetrics.TEST_DATA, details.toString()));
        }
    }
}

