/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.phpunit.PhpUnitCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitResultParser;

public class PhpUnitSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpUnitSensor.class);
    private final Settings settings;
    private final PhpUnitCoverageResultParser coverageParser;
    private final PhpUnitResultParser parser;
    private final ModuleFileSystem fileSystem;

    public PhpUnitSensor(ModuleFileSystem fileSystem, Settings settings, PhpUnitResultParser parser, PhpUnitCoverageResultParser coverageParser) {
        this.fileSystem = fileSystem;
        this.settings = settings;
        this.parser = parser;
        this.coverageParser = coverageParser;
    }

    public void analyse(Project project, SensorContext context) {
        this.parseReport("sonar.php.tests.reportPath", false, "tests");
        this.parseReport("sonar.php.coverage.reportPath", true, "coverage");
    }

    private void parseReport(String reportPathKey, boolean isCoverage, String msg) {
        String reportPath = this.settings.getString(reportPathKey);
        if (reportPath != null) {
            File xmlFile = this.getIOFile(reportPath);
            if (xmlFile.exists()) {
                LOGGER.info("Analyzing PHPUnit " + msg + " report: " + reportPath);
                try {
                    if (isCoverage) {
                        this.coverageParser.parse(xmlFile);
                    }
                    this.parser.parse(xmlFile);
                }
                catch (XStreamException e) {
                    throw new SonarException("Report file is invalid, plugin will stop.", (Throwable)e);
                }
            } else {
                LOGGER.info("PHPUnit xml " + msg + " report not found: " + reportPath);
            }
        } else {
            LOGGER.info("No PHPUnit " + msg + " report provided (see '" + reportPathKey + "' property)");
        }
    }

    private File getIOFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.fileSystem.baseDir(), path);
        }
        return file;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"php"})).isEmpty();
    }

    public String toString() {
        return "PHPUnit Sensor";
    }
}

