/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1134", priority=Priority.MAJOR, name="\"FIXME\" tags should be handled")
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
@ActivatedByDefault
public class FixmeCommentCheck
extends SquidCheck<Grammar>
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "S1134";
    private static final String FIXME_COMMENT_PATTERN = "^#[ ]*fixme.*";
    private Pattern pattern;

    public void visitFile(AstNode astNode) {
        this.pattern = Pattern.compile(FIXME_COMMENT_PATTERN, 2);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (!trivia.isComment() || !this.pattern.matcher(comment = trivia.getToken().getValue()).matches()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Take the required action to fix the issue indicated by this \"FIXME\" comment.", trivia.getToken().getLine(), new Object[0]);
        }
    }
}

