/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="LineLength", priority=Priority.MINOR, name="Lines should not be too long", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LineLengthCheck
extends SquidCheck<Grammar>
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "LineLength";
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="maximumLineLength", defaultValue="120")
    public int maximumLineLength = 120;
    private Token previousToken;

    public int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public void visitFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void leaveFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void visitToken(Token token) {
        if (!token.isGeneratedCode()) {
            if (this.previousToken != null && this.previousToken.getLine() != token.getLine()) {
                String[] lines = this.previousToken.getValue().split("\r?\n|\r", -1);
                int length = this.previousToken.getColumn();
                for (int line = 0; line < lines.length; ++line) {
                    if ((length += lines[line].length()) > this.getMaximumLineLength()) {
                        this.getContext().createLineViolation((CodeCheck)this, "The line contains {0,number,integer} characters which is greater than {1,number,integer} authorized.", this.previousToken.getLine(), new Object[]{length, this.getMaximumLineLength()});
                    }
                    length = 0;
                }
            }
            this.previousToken = token;
        }
    }
}

