/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.python.PythonAstScanner;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.checks.CheckList;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.indexer.QueryByParent;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;

public final class PythonSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final AnnotationCheckFactory annotationCheckFactory;
    private final FileLinesContextFactory fileLinesContextFactory;
    private Project project;
    private SensorContext context;
    private AstScanner<Grammar> scanner;
    private ModuleFileSystem fileSystem;
    private ResourcePerspectives resourcePerspectives;

    public PythonSquidSensor(RulesProfile profile, FileLinesContextFactory fileLinesContextFactory, ModuleFileSystem fileSystem, ResourcePerspectives resourcePerspectives) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"python", (Collection)CheckList.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
        this.resourcePerspectives = resourcePerspectives;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"py"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
        Collection squidChecks = this.annotationCheckFactory.getChecks();
        ArrayList visitors = Lists.newArrayList((Iterable)squidChecks);
        visitors.add(new FileLinesVisitor(project, this.fileLinesContextFactory));
        this.scanner = PythonAstScanner.create((PythonConfiguration)this.createConfiguration(project), (SquidAstVisitor[])visitors.toArray(new SquidAstVisitor[visitors.size()]));
        this.scanner.scanFiles((Collection)this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"py"})));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
    }

    private PythonConfiguration createConfiguration(Project project) {
        return new PythonConfiguration(this.fileSystem.sourceCharset());
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)new File(squidFile.getKey()), (Project)this.project);
            this.saveFilesComplexityDistribution(sonarFile, squidFile);
            this.saveFunctionsComplexityDistribution(sonarFile, squidFile);
            this.saveMeasures(sonarFile, squidFile);
            this.saveIssues(sonarFile, squidFile);
        }
    }

    private void saveMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FILES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FILES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMMENT_LINES)));
    }

    private void saveFunctionsComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        for (SourceCode squidFunction : squidFunctionsInFile) {
            complexityDistribution.add((Number)squidFunction.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveIssues(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                ActiveRule rule = this.annotationCheckFactory.getActiveRule(message.getCheck());
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)sonarFile);
                if (issuable == null) continue;
                Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)rule.getRepositoryKey(), (String)rule.getRuleKey())).line(message.getLine()).message(message.getText(Locale.ENGLISH)).build();
                issuable.addIssue(issue);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

