/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.complexity;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.sonar.plugins.javascript.complexity.JavaScriptFunction;
import org.sonar.plugins.javascript.complexity.JavaScriptPluginException;
import org.sonar.plugins.javascript.cpd.antlr.ES3Lexer;
import org.sonar.plugins.javascript.cpd.antlr.ES3Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptComplexityAnalyzer {
    private List<JavaScriptFunction> functions = new ArrayList<JavaScriptFunction>();
    private int anonymousFunctionCounter = 0;
    private static final String ANONYMOUS_FUNCTION_NAME = "anonymousFunction";
    private static final int[] BRANCHING_NODES = new int[]{18, 16, 30, 23, 8, 9, 96, 13, 94, 95};
    private static TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new CommonTree(payload);
        }
    };

    private boolean isBranchingNode(int nodeCode) {
        for (int code : BRANCHING_NODES) {
            if (code != nodeCode) continue;
            return true;
        }
        return false;
    }

    private void countBranchingStatements(CommonTree tree, JavaScriptFunction function) {
        if (tree != null) {
            if (tree.getType() == 17) {
                function = new JavaScriptFunction();
                function.setLine(tree.getLine());
                function.setColumn(tree.getCharPositionInLine());
                function.setName(this.calculateFunctionName(tree));
                this.functions.add(function);
            }
            if (function != null && this.isBranchingNode(tree.getType())) {
                function.increaseComplexity();
            }
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.countBranchingStatements((CommonTree)tree.getChild(i), function);
            }
        }
    }

    private String calculateFunctionName(CommonTree tree) {
        Tree nameNode;
        Tree node = tree.getChild(0);
        if (node != null && node.getType() == 148) {
            return node.getText();
        }
        node = tree.getParent();
        if (node != null && node.getChild(0) != null && node.getChild(0).getType() == 148) {
            return node.getChild(0).getText();
        }
        node = tree.getParent();
        if (node != null && node.getChild(0) != null && node.getChild(0).getType() == 114 && (nameNode = node.getChild(0).getChild(1)) != null) {
            return nameNode.getText();
        }
        return ANONYMOUS_FUNCTION_NAME + this.anonymousFunctionCounter++;
    }

    public List<JavaScriptFunction> analyzeComplexity(InputStream inputStream) throws JavaScriptPluginException {
        CommonTree tree = this.getJavaScriptAst(inputStream);
        this.countBranchingStatements(tree, null);
        return this.functions;
    }

    protected CommonTree getJavaScriptAst(InputStream inputStream) throws JavaScriptPluginException {
        CommonTree tree = null;
        try {
            ES3Lexer lexer = new ES3Lexer((CharStream)new ANTLRInputStream(inputStream));
            TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
            ES3Parser parser = new ES3Parser((TokenStream)tokens);
            parser.setTreeAdaptor(adaptor);
            ES3Parser.program_return ret = parser.program();
            tree = (CommonTree)ret.getTree();
        }
        catch (IOException e) {
            throw new JavaScriptPluginException("Could not read file", e);
        }
        catch (RecognitionException e) {
            throw new JavaScriptPluginException("Could not parse file", e);
        }
        return tree;
    }
}

