/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.complexity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Violation;
import org.sonar.plugins.javascript.complexity.JavaScriptComplexityAnalyzer;
import org.sonar.plugins.javascript.complexity.JavaScriptFunction;
import org.sonar.plugins.javascript.complexity.JavaScriptPluginException;
import org.sonar.plugins.javascript.core.JavaScript;

public final class JavaScriptComplexitySensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptComplexitySensor.class);
    private JavaScript javascript;
    private RulesProfile rulesProfile;
    private final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};

    public JavaScriptComplexitySensor(JavaScript javascript, RulesProfile rulesProfile) {
        this.javascript = javascript;
        this.rulesProfile = rulesProfile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.javascript.equals(project.getLanguage());
    }

    public void analyse(Project project, SensorContext sensorContext) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"js"})) {
            try {
                this.analyzeFile(inputFile, project, sensorContext);
            }
            catch (Exception e) {
                LOG.error("Can not analyze the file " + inputFile.getFileBaseDir() + inputFile.getRelativePath(), (Throwable)e);
            }
        }
    }

    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        try {
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
            JavaScriptComplexityAnalyzer analyzer = new JavaScriptComplexityAnalyzer();
            List<JavaScriptFunction> functions = analyzer.analyzeComplexity(new FileInputStream(inputFile.getFile()));
            int fileComplexity = 0;
            for (JavaScriptFunction function : functions) {
                fileComplexity += function.getComplexity();
            }
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.COMPLEXITY, Double.valueOf(fileComplexity));
            RangeDistributionBuilder fileDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, this.FILES_DISTRIB_BOTTOM_LIMITS);
            fileDistribution.add((Number)fileComplexity);
            sensorContext.saveMeasure((Resource)resource, fileDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
            if (!functions.isEmpty()) {
                sensorContext.saveMeasure((Resource)resource, CoreMetrics.FUNCTION_COMPLEXITY, Double.valueOf(Double.valueOf(fileComplexity) / (double)functions.size()));
            }
            RangeDistributionBuilder functionDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, this.FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
            for (JavaScriptFunction function : functions) {
                functionDistribution.add((Number)function.getComplexity());
            }
            sensorContext.saveMeasure((Resource)resource, functionDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
            ActiveRule rule = this.rulesProfile.getActiveRule("JavaScript", "CYCLOMATIC_COMPLEXITY");
            if (rule != null) {
                int maxAllowedComplexity = Integer.parseInt(((ActiveRuleParam)rule.getActiveRuleParams().get(0)).getValue());
                for (JavaScriptFunction function : functions) {
                    if (function.getComplexity() <= maxAllowedComplexity) continue;
                    Violation violation = Violation.create((ActiveRule)rule, (Resource)resource);
                    violation.setLineId(Integer.valueOf(function.getLine()));
                    violation.setMessage("Cyclomatic Complexity is " + function.getComplexity() + " (max allowed is " + maxAllowedComplexity + ").");
                    sensorContext.saveViolation(violation);
                }
            }
        }
        catch (JavaScriptPluginException e) {
            LOG.error("Could not analyze file: " + inputFile.getRelativePath(), (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

