/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.cpd;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.javascript.cpd.antlr.ES3Lexer;

public class JavaScriptTokenizer
implements Tokenizer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptTokenizer.class);

    public final void tokenize(SourceCode source, Tokens cpdTokens) {
        String fileName = source.getFileName();
        try {
            ES3Lexer lexer = new ES3Lexer((CharStream)new ANTLRFileStream(fileName));
            Token token = lexer.nextToken();
            while (token.getType() != -1) {
                cpdTokens.add(new TokenEntry(token.getText(), fileName, token.getLine()));
                token = lexer.nextToken();
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File not found", (Throwable)fnfe);
        }
        catch (IOException e) {
            LOG.error("Cannot read file", (Throwable)e);
        }
        cpdTokens.add(TokenEntry.getEOF());
    }
}

