/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jslint;

import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.plugins.javascript.jslint.JavaScriptRuleRepository;

public class JavaScriptDefaultProfile
extends ProfileDefinition {
    private String[] disabledRules = new String[]{"ADSAFE", "STRICT"};
    private JavaScriptRuleRepository repository;

    public JavaScriptDefaultProfile(JavaScriptRuleRepository repository) {
        this.repository = repository;
    }

    public RulesProfile createProfile(ValidationMessages validation) {
        RulesProfile rulesProfile = RulesProfile.create((String)"Default JavaScript Profile", (String)"js");
        for (Rule rule : this.repository.createRules()) {
            if (this.isDisabled(rule)) continue;
            ActiveRule activeRule = rulesProfile.activateRule(rule, null);
            for (RuleParam param : rule.getParams()) {
                activeRule.setParameter(param.getKey(), param.getDefaultValue());
            }
        }
        return rulesProfile;
    }

    private boolean isDisabled(Rule rule) {
        for (String ruleKey : this.disabledRules) {
            if (!ruleKey.equals(rule.getKey())) continue;
            return true;
        }
        return false;
    }
}

