/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jslint;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSIdentifier;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.rules.Violation;
import org.sonar.plugins.javascript.JavaScriptPlugin;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.javascript.jslint.JsLintRuleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptJSLintSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptJSLintSensor.class);
    private Configuration configuration;
    private RulesProfile rulesProfile;
    private RuleFinder ruleFinder;
    private JavaScript javascript;
    private JSLint jsLint;
    private JsLintRuleManager jsLintRuleManager;

    public JavaScriptJSLintSensor(RuleFinder ruleFinder, JavaScript javascript, RulesProfile rulesProfile, JsLintRuleManager jsLintRuleManager, Configuration configuration) {
        this.configuration = configuration;
        this.ruleFinder = ruleFinder;
        this.javascript = javascript;
        this.rulesProfile = rulesProfile;
        this.jsLintRuleManager = jsLintRuleManager;
        this.jsLint = new JSLintBuilder().fromDefault();
        LOG.debug("Using JSLint version: {}", (Object)this.jsLint.getEdition());
        this.initializeJsLint();
    }

    private boolean isActivated(String ruleKey, List<ActiveRule> rules) {
        for (ActiveRule rule : rules) {
            if (!ruleKey.equals(rule.getRuleKey())) continue;
            return true;
        }
        return false;
    }

    public void analyse(Project project, SensorContext sensorContext) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"js"})) {
            try {
                this.analyzeFile(inputFile, project, sensorContext);
            }
            catch (Exception e) {
                LOG.error("Can not analyze the file " + inputFile.getFileBaseDir() + inputFile.getRelativePath(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
        StringReader reader = null;
        try {
            Violation violation;
            reader = new StringReader(FileUtils.readFileToString((File)inputFile.getFile(), (String)project.getFileSystem().getSourceCharset().name()));
            JSLintResult result = this.jsLint.lint(inputFile.getFile().getPath(), (Reader)reader);
            List functions = result.getFunctions();
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.FUNCTIONS, Double.valueOf(functions.size()));
            List issues = result.getIssues();
            for (Issue issue : issues) {
                LOG.debug("JSLint warning message {}", (Object)issue.getRaw());
                Rule rule = this.ruleFinder.findByKey("JavaScript", this.jsLintRuleManager.getRuleIdByMessage(issue.getRaw()));
                violation = Violation.create((Rule)rule, (Resource)resource);
                violation.setLineId(Integer.valueOf(issue.getLine()));
                violation.setMessage(issue.getReason());
                sensorContext.saveViolation(violation);
            }
            List unused = result.getUnused();
            for (JSIdentifier unusedName : unused) {
                violation = Violation.create((Rule)this.ruleFinder.findByKey("JavaScript", "UNUSED_NAMES"), (Resource)resource);
                violation.setLineId(Integer.valueOf(unusedName.getLine()));
                violation.setMessage("'" + unusedName.getName() + "' is unused");
                sensorContext.saveViolation(violation);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getLanguage().equals((Object)this.javascript);
    }

    private void initializeJsLint() {
        RuleQuery query = RuleQuery.create();
        query.withRepositoryKey("JavaScript");
        List activeRules = this.rulesProfile.getActiveRules();
        LOG.debug("Adding JSLint options. Activated rules: {}", (Object)activeRules.size());
        for (Option option : Option.values()) {
            if (!this.jsLintRuleManager.isRuleInverse(option.name()) && this.isActivated(option.name(), activeRules)) {
                LOG.debug("Adding JSLint option from rule: {}", (Object)option.name());
                this.jsLint.addOption(option);
                continue;
            }
            if (!this.jsLintRuleManager.isRuleInverse(option.name()) || this.isActivated(option.name(), activeRules)) continue;
            LOG.debug("Adding JSLint option from inverse rule:  {}", (Object)option.name());
            this.jsLint.addOption(option);
        }
        this.setOptionsSpecifiedAsProjectSettings();
        this.setOptionsSpecifiedAsRuleParameters(activeRules);
    }

    private void setOptionsSpecifiedAsRuleParameters(List<ActiveRule> activeRules) {
        LOG.debug("Adding Options Specified As Rule Parameters");
        for (ActiveRule activeRule : activeRules) {
            for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
                String value = activeRuleParam.getValue();
                Option option = this.jsLintRuleManager.getOptionByName(activeRuleParam.getKey());
                LOG.debug("Rule: " + activeRule.getRuleKey() + ", ruleParam: " + activeRuleParam.getKey() + ", ruleParamValue: " + value);
                if (Option.PREDEF.equals((Object)option)) {
                    value = value + "," + this.getPredefinedVariablesListFromGlobal();
                }
                if (option == null || value == null) continue;
                LOG.debug("Adding JSLint option from rule parameter: {} with value: {}", (Object)option.name(), (Object)value);
                this.jsLint.addOption(option, value);
            }
        }
    }

    private void setOptionsSpecifiedAsProjectSettings() {
        LOG.debug("Adding Options Specified As Project Settings");
        for (String fullparameterName : JavaScriptPlugin.GLOBAL_PARAMETERS) {
            String parameterName = fullparameterName.substring(fullparameterName.lastIndexOf(".") + 1);
            Option option = this.jsLintRuleManager.getOptionByName(parameterName);
            String value = Option.PREDEF.equals((Object)option) ? this.getPredefinedVariablesListFromGlobal() : this.configuration.getString(fullparameterName);
            LOG.debug("Project/global setting name retrieved from global parameter: {} with value {}", (Object)parameterName, (Object)value);
            if (option == null || value == null) continue;
            LOG.debug("Adding JSLint option from project/global settings: {} with value: {}", (Object)option, (Object)value);
            this.jsLint.addOption(option, value);
        }
    }

    private String getPredefinedVariablesListFromGlobal() {
        Object[] predefinedVariables = this.configuration.getStringArray("sonar.javascript.lslint.predef");
        return StringUtils.join((Object[])predefinedVariables, (char)',');
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

