/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jslint;

import com.googlecode.jslint4java.Option;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.ServerExtension;
import org.sonar.plugins.javascript.jslint.JsLintRule;
import org.sonar.plugins.javascript.jslint.JsLintXmlRuleParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsLintRuleManager
implements ServerExtension,
BatchExtension {
    private List<JsLintRule> rules = new ArrayList<JsLintRule>();
    public static final String OTHER_RULES_KEY = "OTHER_RULES";
    public static final String UNUSED_NAMES_KEY = "UNUSED_NAMES";
    public static final String CYCLOMATIC_COMPLEXITY_KEY = "CYCLOMATIC_COMPLEXITY";
    private static final String RULES_FILE_LOCATION = "/org/sonar/plugins/javascript/jslint/rules.xml";

    public JsLintRuleManager() {
        this(RULES_FILE_LOCATION);
    }

    public JsLintRuleManager(String rulesPath) {
        this.rules = new JsLintXmlRuleParser().parse(JsLintRuleManager.class.getResourceAsStream(rulesPath));
    }

    public List<JsLintRule> getJsLintRules() {
        return this.rules;
    }

    public String getRuleIdByMessage(String message) {
        for (JsLintRule rule : this.rules) {
            if (!rule.hasMessage(message)) continue;
            return rule.getKey();
        }
        return OTHER_RULES_KEY;
    }

    public boolean isRuleInverse(String ruleKey) {
        for (JsLintRule rule : this.rules) {
            if (!ruleKey.equals(rule.getKey())) continue;
            return rule.isInverse();
        }
        return false;
    }

    public Option getOptionByName(String name) {
        for (Option o : Option.values()) {
            if (!o.name().equalsIgnoreCase(name)) continue;
            return o;
        }
        return null;
    }
}

