/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jslint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ServerComponent;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.javascript.jslint.JsLintRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsLintXmlRuleParser
implements ServerComponent {
    public List<JsLintRule> parse(File file) {
        List<JsLintRule> list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)FileUtils.openInputStream((File)file), "UTF-8");
            list = this.parse(reader);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Fail to load the file: " + file, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public List<JsLintRule> parse(InputStream input) {
        List<JsLintRule> list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(input, "UTF-8");
            list = this.parse(reader);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Fail to load the xml stream", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public List<JsLintRule> parse(Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            ArrayList<JsLintRule> rules = new ArrayList<JsLintRule>();
            SMInputCursor rulesC = rootC.childElementCursor("rule");
            while (rulesC.getNext() != null) {
                JsLintRule rule = new JsLintRule();
                rules.add(rule);
                JsLintXmlRuleParser.processRule(rule, rulesC);
            }
            return rules;
        }
        catch (XMLStreamException e) {
            throw new SonarException("XML is not valid", (Throwable)e);
        }
    }

    private static void processRule(JsLintRule rule, SMInputCursor ruleC) throws XMLStreamException {
        SMInputCursor cursor = ruleC.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase((String)"name", (String)nodeName)) {
                rule.setName(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)nodeName)) {
                rule.setDescription(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"key", (String)nodeName)) {
                rule.setKey(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"priority", (String)nodeName)) {
                rule.setPriority(RulePriority.valueOf((String)StringUtils.trim((String)cursor.collectDescendantText(false))));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"inverse", (String)nodeName)) {
                rule.setInverse(Boolean.valueOf(StringUtils.trim((String)cursor.collectDescendantText(false))));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"param", (String)nodeName)) {
                JsLintXmlRuleParser.processParameter(rule, cursor);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"messages", (String)nodeName)) continue;
            JsLintXmlRuleParser.processMessages(rule, cursor);
        }
        if (StringUtils.isEmpty((String)rule.getKey())) {
            throw new SonarException("Node <key> is missing in <rule>");
        }
        if (StringUtils.isEmpty((String)rule.getName())) {
            throw new SonarException("Node <name> is missing in <rule>");
        }
    }

    private static void processMessages(JsLintRule rule, SMInputCursor cursor) throws XMLStreamException {
        ArrayList<String> messageList = new ArrayList<String>();
        SMInputCursor messagesCursor = cursor.childElementCursor();
        while (messagesCursor.getNext() != null) {
            String nodeName = messagesCursor.getLocalName();
            String nodeValue = StringUtils.trim((String)messagesCursor.collectDescendantText(false));
            if (!StringUtils.equalsIgnoreCase((String)"message", (String)nodeName)) continue;
            messageList.add(nodeValue);
        }
        rule.setMessages(messageList);
    }

    private static void processParameter(JsLintRule rule, SMInputCursor ruleC) throws XMLStreamException {
        RuleParam param = rule.createParameter();
        SMInputCursor paramC = ruleC.childElementCursor();
        while (paramC.getNext() != null) {
            String propNodeName = paramC.getLocalName();
            String propText = StringUtils.trim((String)paramC.collectDescendantText(false));
            if (StringUtils.equalsIgnoreCase((String)"key", (String)propNodeName)) {
                param.setKey(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)propNodeName)) {
                param.setDescription(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"type", (String)propNodeName)) {
                param.setType(propText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"defaultValue", (String)propNodeName)) continue;
            param.setDefaultValue(propText);
        }
        if (StringUtils.isEmpty((String)param.getKey())) {
            throw new SonarException("Node <key> is missing in <param>");
        }
    }
}

