/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jstestdriver;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.javascript.jstestdriver.JsTestDriverFileCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsTestDriverLCOVParser {
    private static final Logger LOG = LoggerFactory.getLogger(JsTestDriverLCOVParser.class);

    public List<JsTestDriverFileCoverage> parseFile(File file) {
        List lines = new LinkedList();
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            LOG.debug("Cound not read content from file: " + file.getName());
        }
        LinkedList<JsTestDriverFileCoverage> coveredFiles = new LinkedList<JsTestDriverFileCoverage>();
        JsTestDriverFileCoverage fileCoverage = new JsTestDriverFileCoverage();
        for (String line : lines) {
            if (line.indexOf("SF:") > -1) {
                fileCoverage = new JsTestDriverFileCoverage();
                String fullFileName = line.substring(line.indexOf("SF:") + 3);
                fileCoverage.setFullFileName(fullFileName);
                continue;
            }
            if (line.indexOf("DA:") > -1) {
                String execution = line.substring(line.indexOf("DA:") + 3);
                String executionCount = execution.substring(execution.indexOf(44) + 1);
                String lineNumber = execution.substring(0, execution.indexOf(44));
                fileCoverage.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
                continue;
            }
            if (line.indexOf("end_of_record") <= -1) continue;
            coveredFiles.add(fileCoverage);
        }
        return coveredFiles;
    }
}

