/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.squid;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.javascript.squid.JavaScriptRecognizer;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.text.Source;

public final class JavaScriptSquidSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptSquidSensor.class);
    private JavaScript javascript;

    public JavaScriptSquidSensor(JavaScript javascript) {
        this.javascript = javascript;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.javascript.equals(project.getLanguage());
    }

    public void analyse(Project project, SensorContext sensorContext) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"js"})) {
            try {
                this.analyzeFile(inputFile, project, sensorContext);
            }
            catch (Exception e) {
                LOG.error("Can not analyze the file " + inputFile.getFileBaseDir() + inputFile.getRelativePath(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        StringReader reader = null;
        try {
            reader = new StringReader(FileUtils.readFileToString((File)inputFile.getFile(), (String)project.getFileSystem().getSourceCharset().name()));
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
            Source source = new Source((Reader)reader, (CodeRecognizer)new JavaScriptRecognizer(), new String[0]);
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.FILES, Double.valueOf(1.0));
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.LINES, Double.valueOf(source.getMeasure(Metric.LINES)));
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.COMMENT_LINES, Double.valueOf(source.getMeasure(Metric.COMMENT_LINES)));
            sensorContext.saveMeasure((Resource)resource, CoreMetrics.NCLOC, Double.valueOf(source.getMeasure(Metric.LINES_OF_CODE)));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

