/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codemonkey.javareflection.FieldWrapper;
import org.codemonkey.javareflection.JReflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    private FieldUtils() {
    }

    public static Map<Class<?>, List<FieldWrapper>> collectFields(Class<?> _class, Class<?> boundaryMarker, EnumSet<Visibility> visibility, EnumSet<BeanRestriction> beanRestrictions) {
        HashMap fields = new HashMap();
        Field[] allFields = _class.getDeclaredFields();
        LinkedList<FieldWrapper> filteredFields = new LinkedList<FieldWrapper>();
        for (Field field : allFields) {
            FieldWrapper property;
            if (FieldUtils.meetsVisibilityRequirements(field, visibility) && (property = FieldUtils.resolveBeanProperty(field, beanRestrictions)) != null) {
                filteredFields.add(property);
            }
            fields.put(_class, filteredFields);
        }
        List<Class<?>> interfaces = Arrays.asList(_class.getInterfaces());
        if (_class.equals(boundaryMarker) || interfaces.contains(boundaryMarker)) {
            return fields;
        }
        fields.putAll(FieldUtils.collectFields(_class.getSuperclass(), boundaryMarker, visibility, beanRestrictions));
        return fields;
    }

    static boolean meetsVisibilityRequirements(Field field, EnumSet<Visibility> visibility) {
        for (Visibility visibilityModifier : visibility) {
            int m = field.getModifiers();
            if (!(!visibilityModifier.equals((Object)Visibility.DEFAULT) ? (m & visibilityModifier.modifierFlag) != 0 : !Modifier.isPrivate(m) && !Modifier.isProtected(m) && !Modifier.isPublic(m))) continue;
            return true;
        }
        return false;
    }

    static FieldWrapper resolveBeanProperty(Field field, EnumSet<BeanRestriction> beanRestrictions) {
        if (beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_GETTER, BeanRestriction.YES_GETTER)) || beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_SETTER, BeanRestriction.YES_SETTER))) {
            throw new IllegalArgumentException("cannot both include and exclude a setter/getter requirement");
        }
        String setterName = "set" + StringUtils.capitalize((String)field.getName());
        String getterName = field.getType().equals(Boolean.TYPE) ? "is" + StringUtils.capitalize((String)field.getName()) : "get" + StringUtils.capitalize((String)field.getName());
        Method writeMethod = JReflect.findSimpleCompatibleMethod(field.getDeclaringClass(), setterName, field.getType());
        Method readMethod = JReflect.findSimpleCompatibleMethod(field.getDeclaringClass(), getterName, new Class[0]);
        if (!(readMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_GETTER) || readMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_GETTER) || writeMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_SETTER) || writeMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_SETTER))) {
            return new FieldWrapper(field, readMethod, writeMethod);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BeanRestriction {
        YES_GETTER,
        YES_SETTER,
        NO_SETTER,
        NO_GETTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        PRIVATE(2),
        DEFAULT(-1),
        PROTECTED(4),
        PUBLIC(1);

        private int modifierFlag;

        private Visibility(int modifierFlag) {
            this.modifierFlag = modifierFlag;
        }
    }
}

