/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.simplejavamail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.codemonkey.simplejavamail.AttachmentResource;
import org.codemonkey.simplejavamail.Email;
import org.codemonkey.simplejavamail.EmailAddressValidationCriteria;
import org.codemonkey.simplejavamail.EmailValidationUtil;
import org.codemonkey.simplejavamail.MailException;
import org.codemonkey.simplejavamail.Recipient;
import org.codemonkey.simplejavamail.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger logger = LoggerFactory.getLogger(Mailer.class);
    private static final String CHARACTER_ENCODING = "UTF-8";
    private final Session session;
    private TransportStrategy transportStrategy;
    private EmailAddressValidationCriteria emailAddressValidationCriteria;

    public Mailer(Session session) {
        this.session = session;
        this.emailAddressValidationCriteria = null;
    }

    public Mailer(String host, Integer port, String username, String password, TransportStrategy transportStrategy) {
        if (host == null || host.trim().equals("")) {
            throw new MailException("Can't send an email without host");
        }
        if (password != null && !password.trim().equals("") && (username == null || username.trim().equals(""))) {
            throw new MailException("Can't have a password without username");
        }
        this.transportStrategy = transportStrategy;
        this.session = this.createMailSession(host, port, username, password);
        this.emailAddressValidationCriteria = null;
    }

    public Session createMailSession(String host, Integer port, final String username, final String password) {
        if (this.transportStrategy == null) {
            logger.warn("Transport Strategy not set, using plain SMTP strategy instead!");
            this.transportStrategy = TransportStrategy.SMTP_PLAIN;
        }
        Properties props = this.transportStrategy.generateProperties();
        props.put(this.transportStrategy.propertyNameHost(), host);
        if (port != null) {
            props.put(this.transportStrategy.propertyNamePort(), String.valueOf(port));
        }
        if (username != null) {
            props.put(this.transportStrategy.propertyNameUsername(), username);
        }
        if (password != null) {
            props.put(this.transportStrategy.propertyNameAuthenticate(), "true");
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public Mailer(String host, Integer port, String username, String password) {
        this(host, port, username, password, TransportStrategy.SMTP_PLAIN);
    }

    public void setDebug(boolean debug) {
        this.session.setDebug(debug);
    }

    public final void sendMail(Email email) throws MailException {
        if (this.validate(email)) {
            try {
                MimeEmailMessageWrapper messageRoot = new MimeEmailMessageWrapper();
                Message message = this.prepareMessage(email, messageRoot);
                this.logSession(this.session, this.transportStrategy);
                message.saveChanges();
                Transport transport = this.session.getTransport();
                transport.connect();
                transport.sendMessage(message, message.getAllRecipients());
                transport.close();
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new MailException(String.format("Encoding not accepted: %s", e.getMessage()));
            }
            catch (MessagingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new MailException(String.format("Generic error: %s", e.getMessage()), e);
            }
        }
    }

    private void logSession(Session session, TransportStrategy transportStrategy) {
        String specifics;
        Properties properties = session.getProperties();
        if (transportStrategy != null) {
            String logmsg = "starting mail session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)";
            specifics = String.format("starting mail session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)", new Object[]{properties.get(transportStrategy.propertyNameHost()), properties.get(transportStrategy.propertyNamePort()), properties.get(transportStrategy.propertyNameUsername()), properties.get(transportStrategy.propertyNameAuthenticate()), transportStrategy});
        } else {
            specifics = properties.toString();
        }
        logger.debug(String.format("starting mail session (%s)", specifics));
    }

    public boolean validate(Email email) throws MailException {
        if (email.getText() == null && email.getTextHTML() == null) {
            throw new MailException("Email is not valid: missing content body");
        }
        if (email.getSubject() == null || email.getSubject().equals("")) {
            throw new MailException("Email is not valid: missing subject");
        }
        if (email.getRecipients().size() == 0) {
            throw new MailException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailException("Email is not valid: missing sender");
        }
        if (this.emailAddressValidationCriteria != null) {
            if (!EmailValidationUtil.isValid(email.getFromRecipient().getAddress(), this.emailAddressValidationCriteria)) {
                throw new MailException(String.format("Invalid FROM address: %s", email));
            }
            for (Recipient recipient : email.getRecipients()) {
                if (EmailValidationUtil.isValid(recipient.getAddress(), this.emailAddressValidationCriteria)) continue;
                throw new MailException(String.format("Invalid TO address: %s", email));
            }
            if (email.getReplyToRecipient() != null && !EmailValidationUtil.isValid(email.getReplyToRecipient().getAddress(), this.emailAddressValidationCriteria)) {
                throw new MailException(String.format("Invalid REPLY TO address: %s", email));
            }
        }
        return true;
    }

    private Message prepareMessage(Email email, MimeEmailMessageWrapper messageRoot) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
        message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        this.setReplyTo(email, (Message)message);
        this.setRecipients(email, (Message)message);
        this.setTexts(email, messageRoot.multipartAlternativeMessages);
        this.setEmbeddedImages(email, messageRoot.multipartRelated);
        this.setAttachments(email, messageRoot.multipartRoot);
        message.setContent((Multipart)messageRoot.multipartRoot);
        this.setHeaders(email, (Message)message);
        message.setSentDate(new Date());
        return message;
    }

    private void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    private void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getTextHTML() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getTextHTML(), "text/html; charset=\"UTF-8\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(this.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(this.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String headerName = header.getKey();
            String headerValue = MimeUtility.encodeText((String)header.getValue(), (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private BodyPart getBodyPartFromDatasource(AttachmentResource resource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource ds = resource.getDataSource();
        attachmentPart.setDataHandler(new DataHandler(resource.getDataSource()));
        attachmentPart.setFileName(resource.getName());
        attachmentPart.setHeader("Content-Type", ds.getContentType() + "; filename=" + ds.getName() + "; name=" + ds.getName());
        attachmentPart.setHeader("Content-ID", String.format("<%s>", ds.getName()));
        attachmentPart.setDisposition(dispositionType + "; size=0");
        return attachmentPart;
    }

    public void setEmailAddressValidationCriteria(EmailAddressValidationCriteria emailAddressValidationCriteria) {
        this.emailAddressValidationCriteria = emailAddressValidationCriteria;
    }

    private class MimeEmailMessageWrapper {
        private final MimeMultipart multipartRoot = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        MimeEmailMessageWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRoot.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
                this.multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

