/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.simplejavamail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.codemonkey.simplejavamail.MailException;
import org.codemonkey.simplejavamail.TransportStrategy;
import org.codemonkey.simplejavamail.email.AttachmentResource;
import org.codemonkey.simplejavamail.email.Email;
import org.codemonkey.simplejavamail.email.Recipient;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mailer.class);
    private static final String CHARACTER_ENCODING = "UTF-8";
    private final Session session;
    private TransportStrategy transportStrategy;
    private EnumSet<EmailAddressCriteria> emailAddressCriteria = EmailAddressCriteria.RFC_COMPLIANT;

    public Mailer(Session session) {
        this.session = session;
    }

    public Mailer(String host, Integer port, String username, String password, TransportStrategy transportStrategy) {
        if (host == null || host.trim().equals("")) {
            throw new MailException("Can't send an email without host");
        }
        if (password != null && !password.trim().equals("") && (username == null || username.trim().equals(""))) {
            throw new MailException("Can't have a password without username");
        }
        this.transportStrategy = transportStrategy;
        this.session = this.createMailSession(host, port, username, password);
        this.emailAddressCriteria = null;
    }

    protected Session createMailSession(String host, Integer port, final String username, final String password) {
        if (this.transportStrategy == null) {
            LOGGER.warn("Transport Strategy not set, using plain SMTP strategy instead!");
            this.transportStrategy = TransportStrategy.SMTP_PLAIN;
        }
        Properties props = this.transportStrategy.generateProperties();
        props.put(this.transportStrategy.propertyNameHost(), host);
        if (port != null) {
            props.put(this.transportStrategy.propertyNamePort(), String.valueOf(port));
        }
        if (username != null) {
            props.put(this.transportStrategy.propertyNameUsername(), username);
        }
        if (password != null) {
            props.put(this.transportStrategy.propertyNameAuthenticate(), "true");
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public Mailer(String host, Integer port, String username, String password) {
        this(host, port, username, password, TransportStrategy.SMTP_PLAIN);
    }

    public Session getSession() {
        LOGGER.warn("Providing access to Session instance for emergency fall-back scenario. Please let us know why you need it.");
        LOGGER.warn("\t>https://github.com/bbottema/simple-java-mail/issues");
        return this.session;
    }

    public void setDebug(boolean debug) {
        this.session.setDebug(debug);
    }

    public void applyProperties(Properties properties) {
        this.session.getProperties().putAll((Map<?, ?>)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMail(Email email) throws MailException {
        if (this.validate(email)) {
            try {
                MimeMessage message = Mailer.produceMimeMessage(email, this.session);
                this.logSession(this.session, this.transportStrategy);
                message.saveChanges();
                Transport transport = this.session.getTransport();
                try {
                    transport.connect();
                    transport.sendMessage((Message)message, message.getAllRecipients());
                }
                finally {
                    transport.close();
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new MailException(String.format("Encoding not accepted: %s", e.getMessage()));
            }
            catch (MessagingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new MailException(String.format("Generic error: %s", e.getMessage()), (Exception)((Object)e));
            }
        }
    }

    private void logSession(Session session, TransportStrategy transportStrategy) {
        String specifics;
        Properties properties = session.getProperties();
        if (transportStrategy != null) {
            String logmsg = "starting mail session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)";
            specifics = String.format("starting mail session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)", new Object[]{properties.get(transportStrategy.propertyNameHost()), properties.get(transportStrategy.propertyNamePort()), properties.get(transportStrategy.propertyNameUsername()), properties.get(transportStrategy.propertyNameAuthenticate()), transportStrategy});
        } else {
            specifics = properties.toString();
        }
        LOGGER.debug(String.format("starting mail session (%s)", specifics));
    }

    public boolean validate(Email email) throws MailException {
        if (email.getText() == null && email.getTextHTML() == null) {
            throw new MailException("Email is not valid: missing content body");
        }
        if (email.getSubject() == null || email.getSubject().equals("")) {
            throw new MailException("Email is not valid: missing subject");
        }
        if (email.getRecipients().size() == 0) {
            throw new MailException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailException("Email is not valid: missing sender");
        }
        if (this.emailAddressCriteria != null) {
            if (!EmailAddressValidator.isValid(email.getFromRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailException(String.format("Invalid FROM address: %s", email));
            }
            for (Recipient recipient : email.getRecipients()) {
                if (EmailAddressValidator.isValid(recipient.getAddress(), this.emailAddressCriteria)) continue;
                throw new MailException(String.format("Invalid TO address: %s", email));
            }
            if (email.getReplyToRecipient() != null && !EmailAddressValidator.isValid(email.getReplyToRecipient().getAddress(), this.emailAddressCriteria)) {
                throw new MailException(String.format("Invalid REPLY TO address: %s", email));
            }
        }
        return true;
    }

    public static MimeMessage produceMimeMessage(Email email, Session session) throws MessagingException, UnsupportedEncodingException {
        if (email == null) {
            throw new IllegalStateException("email is missing");
        }
        if (session == null) {
            throw new IllegalStateException("session is needed, it cannot be attached later");
        }
        MimeEmailMessageWrapper messageRoot = new MimeEmailMessageWrapper();
        MimeMessage message = new MimeMessage(session);
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
        message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        Mailer.setReplyTo(email, (Message)message);
        Mailer.setRecipients(email, (Message)message);
        Mailer.setTexts(email, messageRoot.multipartAlternativeMessages);
        Mailer.setEmbeddedImages(email, messageRoot.multipartRelated);
        Mailer.setAttachments(email, messageRoot.multipartRoot);
        message.setContent((Multipart)messageRoot.multipartRoot);
        Mailer.setHeaders(email, (Message)message);
        message.setSentDate(new Date());
        return message;
    }

    private static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private static void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    private static void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getTextHTML() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getTextHTML(), "text/html; charset=\"UTF-8\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private static void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(Mailer.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private static void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(Mailer.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private static void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String headerName = header.getKey();
            String headerValue = MimeUtility.encodeText((String)header.getValue(), (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource dataSource = attachmentResource.getDataSource();
        String resourceName = attachmentResource.getName();
        boolean dataSourceNameProvided = dataSource.getName() != null && !dataSource.getName().isEmpty();
        String fileName = dataSourceNameProvided ? dataSource.getName() : resourceName;
        attachmentPart.setDataHandler(new DataHandler(attachmentResource.getDataSource()));
        attachmentPart.setFileName(fileName);
        attachmentPart.setHeader("Content-Type", dataSource.getContentType() + "; filename=" + fileName + "; name=" + fileName);
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setDisposition(dispositionType + "; size=0");
        return attachmentPart;
    }

    public void setEmailAddressCriteria(EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        this.emailAddressCriteria = emailAddressCriteria;
    }

    private static class MimeEmailMessageWrapper {
        private final MimeMultipart multipartRoot = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        MimeEmailMessageWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRoot.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
                this.multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

