/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.simplejavamail.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.codemonkey.simplejavamail.MailException;
import org.codemonkey.simplejavamail.email.AttachmentResource;
import org.codemonkey.simplejavamail.email.EqualsHelper;
import org.codemonkey.simplejavamail.email.Recipient;
import org.codemonkey.simplejavamail.util.MimeMessageParser;

public class Email {
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients;
    private final List<AttachmentResource> embeddedImages;
    private final List<AttachmentResource> attachments;
    private final Map<String, String> headers;
    private static final String PARSE_MIMEMESSAGE_ERROR = "Error parsing MimeMessage: %s";

    public Email() {
        this.recipients = new ArrayList<Recipient>();
        this.embeddedImages = new ArrayList<AttachmentResource>();
        this.attachments = new ArrayList<AttachmentResource>();
        this.headers = new HashMap<String, String>();
    }

    public void setFromAddress(String name, String fromAddress) {
        this.fromRecipient = new Recipient(name, fromAddress, null);
        if (this.replyToRecipient == null) {
            this.setReplyToAddress(name, fromAddress);
        }
    }

    public void setReplyToAddress(String name, String replyToAddress) {
        this.replyToRecipient = new Recipient(name, replyToAddress, null);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextHTML(String textHTML) {
        this.textHTML = textHTML;
    }

    public void addRecipient(String name, String address, Message.RecipientType type) {
        this.recipients.add(new Recipient(name, address, type));
    }

    public void addEmbeddedImage(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(String name, DataSource imagedata) {
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addAttachment(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addAttachment(name, (DataSource)dataSource);
    }

    public void addAttachment(String name, DataSource filedata) {
        this.attachments.add(new AttachmentResource(name, filedata));
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        return "Email{\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients + ",\n\tembeddedImages=" + this.embeddedImages + ",\n\tattachments=" + this.attachments + ",\n\theaders=" + this.headers + "\n}";
    }

    private Email(Builder builder) {
        this.recipients = builder.recipients;
        this.embeddedImages = builder.embeddedImages;
        this.attachments = builder.attachments;
        this.headers = builder.headers;
        this.fromRecipient = builder.fromRecipient;
        this.replyToRecipient = builder.replyToRecipient;
        this.text = builder.text;
        this.textHTML = builder.textHTML;
        this.subject = builder.subject;
    }

    public Email(MimeMessage mimeMessage) {
        this();
        try {
            this.fillEmailFromMimeMessage(new MimeMessageParser(mimeMessage).parse());
        }
        catch (MessagingException e) {
            throw new MailException(String.format(PARSE_MIMEMESSAGE_ERROR, e.getMessage()), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailException(String.format(PARSE_MIMEMESSAGE_ERROR, e.getMessage()), e);
        }
    }

    private void fillEmailFromMimeMessage(MimeMessageParser parser) throws MessagingException {
        InternetAddress from = parser.getFrom();
        this.setFromAddress(from.getPersonal(), from.getAddress());
        InternetAddress replyTo = parser.getReplyTo();
        this.setReplyToAddress(replyTo.getPersonal(), replyTo.getAddress());
        for (Map.Entry<String, Object> entry : parser.getHeaders().entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        for (InternetAddress internetAddress : parser.getTo()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.TO);
        }
        for (InternetAddress internetAddress : parser.getCc()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.CC);
        }
        for (InternetAddress internetAddress : parser.getBcc()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.BCC);
        }
        this.setSubject(parser.getSubject());
        this.setText(parser.getPlainContent());
        this.setTextHTML(parser.getHtmlContent());
        for (Map.Entry<String, Object> entry : parser.getCidMap().entrySet()) {
            this.addEmbeddedImage(Email.extractCID(entry.getKey()), (DataSource)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : parser.getAttachmentList().entrySet()) {
            this.addAttachment(Email.extractCID(entry.getKey()), (DataSource)entry.getValue());
        }
    }

    static String extractCID(String cid) {
        return cid != null ? cid.replaceAll("<?([^>]*)>?", "$1") : null;
    }

    public static class Builder {
        private Recipient fromRecipient;
        private Recipient replyToRecipient;
        private String text;
        private String textHTML;
        private String subject;
        private final List<Recipient> recipients = new ArrayList<Recipient>();
        private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
        private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
        private final Map<String, String> headers = new HashMap<String, String>();

        public Email build() {
            return new Email(this);
        }

        public Builder from(String name, String fromAddress) {
            this.fromRecipient = new Recipient(name, fromAddress, null);
            return this;
        }

        public Builder replyTo(String name, String replyToAddress) {
            this.replyToRecipient = new Recipient(name, replyToAddress, null);
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder textHTML(String textHTML) {
            this.textHTML = textHTML;
            return this;
        }

        public Builder to(String name, String address) {
            this.recipients.add(new Recipient(name, address, Message.RecipientType.TO));
            return this;
        }

        public Builder to(Recipient recipient) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.TO));
            return this;
        }

        public Builder cc(String name, String address) {
            this.recipients.add(new Recipient(name, address, Message.RecipientType.CC));
            return this;
        }

        public Builder cc(Recipient recipient) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.CC));
            return this;
        }

        public Builder bcc(String name, String address) {
            this.recipients.add(new Recipient(name, address, Message.RecipientType.BCC));
            return this;
        }

        public Builder bcc(Recipient recipient) {
            this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), Message.RecipientType.BCC));
            return this;
        }

        public Builder embedImage(String name, byte[] data, String mimetype) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
            dataSource.setName(name);
            return this.embedImage(name, (DataSource)dataSource);
        }

        public Builder embedImage(String name, DataSource imagedata) {
            this.embeddedImages.add(new AttachmentResource(name, imagedata));
            return this;
        }

        public Builder addHeader(String name, Object value) {
            this.headers.put(name, String.valueOf(value));
            return this;
        }

        public void addAttachment(String name, byte[] data, String mimetype) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
            dataSource.setName(name);
            this.addAttachment(name, (DataSource)dataSource);
        }

        public void addAttachment(String name, DataSource filedata) {
            this.attachments.add(new AttachmentResource(name, filedata));
        }
    }
}

