/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.regex.Matcher;
import javax.mail.internet.InternetAddress;
import org.hazlewood.connor.bottema.emailaddress.Dragons;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;

public final class EmailAddressParser {
    private EmailAddressParser() {
    }

    public static boolean isValidReturnPath(String email, EnumSet<EmailAddressCriteria> criteria) {
        return email != null && Dragons.fromCriteria(criteria).RETURN_PATH_PATTERN.matcher(email).matches();
    }

    public static String getReturnPathBracketContents(String email, EnumSet<EmailAddressCriteria> criteria) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).RETURN_PATH_PATTERN.matcher(email);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String getReturnPathAddress(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        if (EmailAddressParser.isValidReturnPath(email, criteria)) {
            InternetAddress ia = EmailAddressParser.getInternetAddress(email, criteria, extractCfwsPersonalNames);
            if (ia == null) {
                return "";
            }
            return ia.getAddress();
        }
        return null;
    }

    public static boolean isValidMailboxList(String header_txt, EnumSet<EmailAddressCriteria> criteria) {
        return Dragons.fromCriteria(criteria).MAILBOX_LIST_PATTERN.matcher(header_txt).matches();
    }

    public static boolean isValidAddressList(String header_txt, EnumSet<EmailAddressCriteria> criteria) {
        boolean valid = false;
        Matcher m = Dragons.fromCriteria(criteria).ADDRESS_PATTERN.matcher(header_txt);
        int max = header_txt.length();
        while (m.lookingAt()) {
            if (m.end() == max) {
                valid = true;
                break;
            }
            valid = false;
            if (header_txt.charAt(m.end()) != ',') break;
            m.region(m.end() + 1, max);
        }
        return valid;
    }

    public static InternetAddress getInternetAddress(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        if (m.matches()) {
            return EmailAddressParser.pullFromGroups(m, criteria, extractCfwsPersonalNames);
        }
        return null;
    }

    public static String[] getAddressParts(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        if (m.matches()) {
            return EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames);
        }
        return null;
    }

    public static String getPersonalName(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        if (m.matches()) {
            return EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[0];
        }
        return null;
    }

    public static String getLocalPart(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        if (m.matches()) {
            return EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[1];
        }
        return null;
    }

    public static String getDomain(String email, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        if (m.matches()) {
            return EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[2];
        }
        return null;
    }

    public static InternetAddress[] extractHeaderAddresses(String header_txt, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (header_txt == null || header_txt.equals("")) {
            return new InternetAddress[0];
        }
        Dragons dragons = Dragons.fromCriteria(criteria);
        Matcher m = dragons.MAILBOX_PATTERN.matcher(header_txt);
        Matcher gp = dragons.GROUP_PREFIX_PATTERN.matcher(header_txt);
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>(1);
        int max = header_txt.length();
        boolean group_start = false;
        boolean group_end = false;
        int next_comma_index = -1;
        int next_semicolon_index = -1;
        int just_after_group_end = -1;
        while (true) {
            if (group_end) {
                next_comma_index = header_txt.indexOf(44, just_after_group_end);
                if (next_comma_index < 0 || next_comma_index >= max - 1) break;
                gp.region(next_comma_index + 1, max);
                m.region(next_comma_index + 1, max);
                group_end = false;
            }
            if (header_txt.charAt(m.regionStart()) == ';') {
                group_start = false;
                m.region(m.regionStart() + 1, max);
                if (m.regionStart() >= max) break;
                gp.region(m.regionStart(), max);
                group_end = true;
                just_after_group_end = m.regionStart();
            }
            if (m.lookingAt()) {
                group_start = false;
                if (m.end() != max && header_txt.charAt(m.end()) != ',' && !(group_end = header_txt.charAt(m.end()) == ';')) break;
                InternetAddress cur_addr = EmailAddressParser.pullFromGroups(m, criteria, extractCfwsPersonalNames);
                if (cur_addr != null) {
                    result.add(cur_addr);
                }
                if (m.end() >= max - 1) break;
                if (!group_end) {
                    gp.region(m.end() + 1, max);
                    m.region(m.end() + 1, max);
                    continue;
                }
                just_after_group_end = m.end() + 1;
                continue;
            }
            if (gp.lookingAt()) {
                if (gp.end() >= max) break;
                m.region(gp.end(), max);
                gp.region(gp.end(), max);
                group_start = true;
                continue;
            }
            if (group_start) {
                next_semicolon_index = header_txt.indexOf(59, m.regionStart());
                if (next_semicolon_index < 0 || next_semicolon_index >= max - 1) break;
                m.region(next_semicolon_index + 1, max);
                gp.region(next_semicolon_index + 1, max);
                group_start = false;
                group_end = true;
                just_after_group_end = m.regionStart();
                continue;
            }
            if (!group_end) break;
        }
        return result.size() > 0 ? result.toArray(new InternetAddress[result.size()]) : new InternetAddress[]{};
    }

    public static InternetAddress pullFromGroups(Matcher m, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        InternetAddress current_ia = null;
        String[] parts = EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames);
        if (parts[1] == null || parts[2] == null) {
            return null;
        }
        try {
            current_ia = new InternetAddress();
            current_ia.setPersonal(parts[0]);
            current_ia.setAddress(parts[1] + "@" + parts[2]);
        }
        catch (UnsupportedEncodingException uee) {
            current_ia = null;
        }
        return current_ia;
    }

    public static String[] getMatcherParts(Matcher m, EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        String test_addr;
        String current_localpart = null;
        String current_domainpart = null;
        String local_part_da = null;
        String local_part_qs = null;
        String domain_part_da = null;
        String domain_part_dl = null;
        String personal_string = null;
        boolean allowDomainLiterals = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS);
        if (criteria.contains((Object)EmailAddressCriteria.ALLOW_QUOTED_IDENTIFIERS)) {
            if (allowDomainLiterals) {
                if (m.group(1) != null) {
                    local_part_da = m.group(5);
                    if (local_part_da == null) {
                        local_part_qs = m.group(6);
                    }
                    if ((domain_part_da = m.group(7)) == null) {
                        domain_part_dl = m.group(8);
                    }
                    current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                    current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
                    personal_string = m.group(2);
                    if (personal_string == null && extractCfwsPersonalNames) {
                        personal_string = m.group(9);
                        personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                    }
                } else if (m.group(10) != null) {
                    local_part_da = m.group(12);
                    if (local_part_da == null) {
                        local_part_qs = m.group(13);
                    }
                    if ((domain_part_da = m.group(14)) == null) {
                        domain_part_dl = m.group(15);
                    }
                    current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                    String string = current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
                    if (extractCfwsPersonalNames) {
                        personal_string = m.group(16);
                        personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                    }
                }
            } else if (m.group(1) != null) {
                local_part_da = m.group(5);
                if (local_part_da == null) {
                    local_part_qs = m.group(6);
                }
                current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                current_domainpart = m.group(7);
                personal_string = m.group(2);
                if (personal_string == null && extractCfwsPersonalNames) {
                    personal_string = m.group(8);
                    personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                }
            } else if (m.group(9) != null) {
                local_part_da = m.group(11);
                if (local_part_da == null) {
                    local_part_qs = m.group(12);
                }
                current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                current_domainpart = m.group(13);
                if (extractCfwsPersonalNames) {
                    personal_string = m.group(14);
                    personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                }
            }
        } else {
            local_part_da = m.group(3);
            if (local_part_da == null) {
                local_part_qs = m.group(4);
            }
            if ((domain_part_da = m.group(5)) == null && allowDomainLiterals) {
                domain_part_dl = m.group(6);
            }
            current_localpart = local_part_da == null ? local_part_qs : local_part_da;
            String string = current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
            if (extractCfwsPersonalNames) {
                personal_string = m.group((allowDomainLiterals ? 1 : 0) + 6);
                personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
            }
        }
        if (current_localpart != null) {
            current_localpart = current_localpart.trim();
        }
        if (current_domainpart != null) {
            current_domainpart = current_domainpart.trim();
        }
        if (personal_string != null) {
            personal_string = personal_string.trim();
            personal_string = EmailAddressParser.cleanupPersonalString(personal_string, criteria);
        }
        if (Dragons.fromCriteria(criteria).ADDR_SPEC_PATTERN.matcher(test_addr = EmailAddressParser.removeAnyBounding('\"', '\"', current_localpart) + "@" + current_domainpart).matches()) {
            current_localpart = EmailAddressParser.removeAnyBounding('\"', '\"', current_localpart);
        }
        return new String[]{personal_string, current_localpart, current_domainpart};
    }

    public static String getFirstComment(String text, EnumSet<EmailAddressCriteria> criteria) {
        if (text == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).COMMENT_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group().trim();
    }

    public static String cleanupPersonalString(String text, EnumSet<EmailAddressCriteria> criteria) {
        if (text == null) {
            return null;
        }
        text = text.trim();
        Dragons dragons = Dragons.fromCriteria(criteria);
        Matcher m = dragons.QUOTED_STRING_WO_CFWS_PATTERN.matcher(text);
        if (!m.matches()) {
            return text;
        }
        text = EmailAddressParser.removeAnyBounding('\"', '\"', m.group());
        text = dragons.ESCAPED_BSLASH_PATTERN.matcher(text).replaceAll("\\\\");
        text = dragons.ESCAPED_QUOTE_PATTERN.matcher(text).replaceAll("\"");
        return text.trim();
    }

    public static String removeAnyBounding(char s, char e, String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        if (str.startsWith(String.valueOf(s)) && str.endsWith(String.valueOf(e))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

