/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;

public abstract class JacksonJSONContext<M extends Message.Mutable, I extends M> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JavaType rootArrayType = this.objectMapper.constructType(this.rootArrayClass());

    protected JacksonJSONContext() {
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected abstract Class<I[]> rootArrayClass();

    public M[] parse(InputStream stream) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(stream, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public M[] parse(Reader reader) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(reader, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public M[] parse(String json) throws ParseException {
        try {
            return (Message.Mutable[])this.getObjectMapper().readValue(json, this.rootArrayType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    public JSONContext.AsyncParser newAsyncParser() {
        try {
            JsonParser jsonParser = this.objectMapper.getFactory().createNonBlockingByteArrayParser();
            return new AsyncJsonParser(jsonParser);
        }
        catch (Throwable x) {
            return null;
        }
    }

    public String generate(M message) {
        try {
            return this.getObjectMapper().writeValueAsString(message);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public String generate(List<M> messages) {
        try {
            Message.Mutable[] mutables = new Message.Mutable[messages.size()];
            messages.toArray(mutables);
            return this.getObjectMapper().writeValueAsString((Object)mutables);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public JSONContext.Parser getParser() {
        return new ObjectMapperParser();
    }

    public JSONContext.Generator getGenerator() {
        return new ObjectMapperGenerator();
    }

    private class AsyncJsonParser
    implements JSONContext.AsyncParser {
        private final JsonParser jsonParser;
        private final TokenBuffer tokenBuffer;

        public AsyncJsonParser(JsonParser jsonParser) {
            this.jsonParser = jsonParser;
            this.tokenBuffer = new TokenBuffer(jsonParser);
        }

        @Override
        public void parse(byte[] bytes, int offset, int length) {
            block4: {
                try {
                    NonBlockingInputFeeder feeder = this.jsonParser.getNonBlockingInputFeeder();
                    if (feeder instanceof ByteArrayFeeder) {
                        ((ByteArrayFeeder)feeder).feedInput(bytes, offset, offset + length);
                        this.parseInput();
                        break block4;
                    }
                    if (feeder instanceof ByteBufferFeeder) {
                        this.parse(ByteBuffer.wrap(bytes, offset, length));
                        break block4;
                    }
                    throw new UnsupportedOperationException();
                }
                catch (IOException x) {
                    throw new IllegalStateException(x);
                }
            }
        }

        @Override
        public void parse(ByteBuffer buffer) {
            block6: {
                try {
                    NonBlockingInputFeeder feeder = this.jsonParser.getNonBlockingInputFeeder();
                    if (feeder instanceof ByteBufferFeeder) {
                        ((ByteBufferFeeder)feeder).feedInput(buffer);
                        this.parseInput();
                        break block6;
                    }
                    if (feeder instanceof ByteArrayFeeder) {
                        if (buffer.hasArray()) {
                            this.parse(buffer.array(), buffer.arrayOffset(), buffer.remaining());
                        } else {
                            byte[] bytes = new byte[buffer.remaining()];
                            buffer.get(bytes);
                            this.parse(bytes, 0, bytes.length);
                        }
                        break block6;
                    }
                    throw new UnsupportedOperationException();
                }
                catch (IOException x) {
                    throw new IllegalStateException(x);
                }
            }
        }

        private void parseInput() throws IOException {
            JsonToken jsonToken;
            while ((jsonToken = this.jsonParser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                this.tokenBuffer.copyCurrentEvent(this.jsonParser);
            }
        }

        @Override
        public <R> R complete() {
            try {
                NonBlockingInputFeeder feeder = this.jsonParser.getNonBlockingInputFeeder();
                feeder.endOfInput();
                this.jsonParser.nextToken();
                Message.Mutable[] result = (Message.Mutable[])JacksonJSONContext.this.objectMapper.readValue(this.tokenBuffer.asParser(), JacksonJSONContext.this.objectMapper.constructType(JacksonJSONContext.this.rootArrayClass()));
                return (R)Arrays.asList(result);
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
        }
    }

    private class ObjectMapperParser
    implements JSONContext.Parser {
        private ObjectMapperParser() {
        }

        @Override
        public <R> R parse(Reader reader, Class<R> type) throws ParseException {
            try {
                return (R)JacksonJSONContext.this.getObjectMapper().readValue(reader, type);
            }
            catch (IOException x) {
                throw (ParseException)new ParseException("", -1).initCause(x);
            }
        }
    }

    protected class ObjectMapperGenerator
    implements JSONContext.Generator {
        protected ObjectMapperGenerator() {
        }

        @Override
        public String generate(Object object) {
            try {
                return JacksonJSONContext.this.getObjectMapper().writeValueAsString(object);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

