/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.ChannelId;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class AbstractService {
    private final String _name;
    private final BayeuxServerImpl _bayeux;
    private final LocalSession _session;
    private final Map<String, Method> _methods = new ConcurrentHashMap<String, Method>();
    private final Map<ChannelId, Method> _wild = new ConcurrentHashMap<ChannelId, Method>();
    private ThreadPool _threadPool;
    private boolean _seeOwn = false;
    private final Logger _logger;

    public AbstractService(BayeuxServer bayeux, String name) {
        this(bayeux, name, 0);
    }

    public AbstractService(BayeuxServer bayeux, String name, int maxThreads) {
        if (maxThreads > 0) {
            this.setThreadPool((ThreadPool)new QueuedThreadPool(maxThreads));
        }
        this._name = name;
        this._bayeux = (BayeuxServerImpl)bayeux;
        this._session = this._bayeux.newLocalSession(name);
        this._session.handshake();
        this._logger = ((BayeuxServerImpl)bayeux).getLogger();
    }

    public BayeuxServer getBayeux() {
        return this._bayeux;
    }

    public LocalSession getLocalSession() {
        return this._session;
    }

    public ServerSession getServerSession() {
        return this._session.getServerSession();
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        try {
            if (pool instanceof LifeCycle && !((LifeCycle)pool).isStarted()) {
                ((LifeCycle)pool).start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._threadPool = pool;
    }

    public boolean isSeeOwnPublishes() {
        return this._seeOwn;
    }

    public void setSeeOwnPublishes(boolean own) {
        this._seeOwn = own;
    }

    protected void addService(String channelId, String methodName) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("subscribe " + this._name + "#" + methodName + " to " + channelId, new Object[0]);
        }
        Method method = null;
        for (Class<?> c = this.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            int i = methods.length;
            while (i-- > 0) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Multiple methods called '" + methodName + "'");
                }
                method = methods[i];
            }
        }
        if (method == null) {
            throw new NoSuchMethodError(methodName);
        }
        int params = method.getParameterTypes().length;
        if (params < 2 || params > 4) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have 2or3 parameters");
        }
        if (!ServerSession.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have Session as first parameter");
        }
        this._bayeux.createIfAbsent(channelId, new ConfigurableServerChannel.Initializer[0]);
        ServerChannel channel = this._bayeux.getChannel(channelId);
        if (channel.isWild()) {
            this._wild.put(new ChannelId(channel.getId()), method);
        } else {
            this._methods.put(channelId, method);
        }
        final Method invoke = method;
        channel.addListener((ServerChannel.ServerChannelListener)new ServerChannel.MessageListener(){

            public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
                if (AbstractService.this._seeOwn || from != AbstractService.this.getServerSession()) {
                    AbstractService.this.invoke(invoke, from, (ServerMessage)message);
                }
                return true;
            }
        });
    }

    protected void send(ServerSession toClient, String onChannel, Object data, String id) {
        toClient.deliver((Session)this._session.getServerSession(), onChannel, data, id);
    }

    protected void exception(String method, ServerSession fromClient, LocalSession toClient, ServerMessage msg, Throwable th) {
        System.err.println(method + ": " + msg);
        th.printStackTrace();
    }

    private void invoke(final Method method, final ServerSession fromClient, final ServerMessage msg) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("invoke " + this._name + "#" + method.getName() + " from " + fromClient + " with " + msg.getData(), new Object[0]);
        }
        if (this._threadPool == null) {
            this.doInvoke(method, fromClient, msg);
        } else {
            this._threadPool.dispatch(new Runnable(){

                @Override
                public void run() {
                    AbstractService.this.doInvoke(method, fromClient, msg);
                }
            });
        }
    }

    protected void doInvoke(Method method, ServerSession fromClient, ServerMessage msg) {
        String channel = msg.getChannel();
        Object data = msg.getData();
        String id = msg.getId();
        if (method != null) {
            try {
                Class<?>[] args = method.getParameterTypes();
                Object arg = Message.class.isAssignableFrom(args[1]) ? msg : data;
                Object reply = null;
                switch (method.getParameterTypes().length) {
                    case 2: {
                        reply = method.invoke((Object)this, fromClient, arg);
                        break;
                    }
                    case 3: {
                        reply = method.invoke((Object)this, fromClient, arg, id);
                        break;
                    }
                    case 4: {
                        reply = method.invoke((Object)this, fromClient, channel, arg, id);
                    }
                }
                if (reply != null) {
                    this.send(fromClient, channel, reply, id);
                }
            }
            catch (Exception e) {
                this.exception(method.toString(), fromClient, this._session, msg, e);
            }
            catch (Error e) {
                this.exception(method.toString(), fromClient, this._session, msg, e);
            }
        }
    }
}

