/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ServerTransport;
import org.cometd.server.transports.HttpTransport;
import org.cometd.server.transports.JSONPTransport;
import org.cometd.server.transports.JSONTransport;
import org.cometd.server.transports.WebSocketTransport;

public class CometdServlet
extends GenericServlet {
    public static final int CONFIG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int DEBUG_LEVEL = 3;
    public static final String CLIENT_ATTR = "org.cometd.server.client";
    public static final String TRANSPORT_ATTR = "org.cometd.server.transport";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String HTTP_CLIENT_ID = "BAYEUX_HTTP_CLIENT";
    private final BayeuxServerImpl _bayeux = new BayeuxServerImpl();
    private final JSONTransport _lpTransport = new JSONTransport(this._bayeux, this._bayeux.getOptions());
    private final JSONPTransport _cbTransport = new JSONPTransport(this._bayeux, this._bayeux.getOptions());
    private final WebSocketTransport _wsTransport = new WebSocketTransport(this._bayeux, this._bayeux.getOptions());
    private final ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal();
    private String _transportParameter;
    private String _callbackParameter;
    private boolean _useWS;
    private boolean _useLP;
    private boolean _useCB;
    private int _logLevel;
    private static ServerMessage.Mutable[] __EMPTY_BATCH = new ServerMessage.Mutable[0];

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    protected void initializeBayeux(BayeuxServerImpl bayeux) {
        bayeux.addTransport(this._wsTransport);
        bayeux.addTransport(this._lpTransport);
        bayeux.addTransport(this._cbTransport);
        bayeux.setAllowedTransports("websocket", "long-polling", "callback-polling");
    }

    public void init() throws ServletException {
        Transport transport;
        if (this.getInitParameter("logLevel") != null) {
            this._logLevel = Integer.parseInt(this.getInitParameter("logLevel"));
            if (this._logLevel >= 3) {
                this._bayeux.getLogger().setDebugEnabled(true);
            }
        }
        this.initializeBayeux(this._bayeux);
        this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this._bayeux);
        HashSet<String> qualified_names = new HashSet<String>();
        for (String string : this._bayeux.getKnownTransportNames()) {
            transport = this._bayeux.getTransport(string);
            for (String option : transport.getOptionNames()) {
                qualified_names.add(option);
                String prefix = transport.getOptionPrefix();
                while (prefix != null) {
                    qualified_names.add(prefix + "." + option);
                    int dot = prefix.lastIndexOf(46);
                    prefix = dot < 0 ? null : prefix.substring(0, dot);
                }
            }
        }
        for (String string : qualified_names) {
            String value = this.getInitParameter(string);
            if (value == null) continue;
            this._bayeux.setOption(string, value);
        }
        for (String string : this._bayeux.getKnownTransportNames()) {
            transport = this._bayeux.getTransport(string);
            if (!(transport instanceof ServerTransport)) continue;
            ((ServerTransport)transport).init();
        }
        if (this._logLevel >= 1) {
            for (Map.Entry entry : this._bayeux.getOptions().entrySet()) {
                this.getServletContext().log((String)entry.getKey() + "=" + entry.getValue());
            }
        }
        this._useLP = this._bayeux.getAllowedTransports().contains("long-polling");
        this._useCB = this._bayeux.getAllowedTransports().contains("callback-polling");
        this._useWS = this._bayeux.getAllowedTransports().contains("callback-polling");
        this._callbackParameter = this._cbTransport.getCallbackParameter();
        try {
            this._bayeux.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this._currentRequest.set(request);
        try {
            this.service(request, response);
        }
        finally {
            this._currentRequest.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String transport_name;
        HttpTransport transport = null;
        if (this._transportParameter != null && (transport_name = request.getParameter(this._transportParameter)) != null) {
            transport = (HttpTransport)this._bayeux.getTransport(transport_name);
        }
        if (transport == null) {
            if (this._useCB && request.getParameter(this._callbackParameter) != null) {
                transport = this._cbTransport;
            } else if (this._useWS && "WebSocket".equals(request.getHeader("Upgrade"))) {
                transport = this._wsTransport;
            } else if (this._useLP) {
                transport = this._lpTransport;
            }
        }
        if (transport == null) {
            response.sendError(400, "bad transport");
        } else {
            try {
                this._bayeux.setCurrentTransport(transport);
                transport.setCurrentRequest(request);
                transport.handle(request, response);
            }
            finally {
                this._bayeux.setCurrentTransport(null);
                transport.setCurrentRequest(null);
            }
        }
    }

    protected ServerMessage.Mutable[] getMessages(HttpServletRequest request) throws IOException {
        String fodder = null;
        try {
            if (request.getContentType() != null && !request.getContentType().startsWith("application/x-www-form-urlencoded")) {
                return this._bayeux.getServerMessagePool().parseMessages(request.getReader());
            }
            String[] batches = request.getParameterValues(MESSAGE_PARAM);
            if (batches == null || batches.length == 0) {
                return __EMPTY_BATCH;
            }
            if (batches.length == 0) {
                fodder = batches[0];
                return this._bayeux.getServerMessagePool().parseMessages(fodder);
            }
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(fodder, e);
        }
    }

    public void destroy() {
        for (ServerSessionImpl session : this._bayeux.getSessions()) {
            session.cancelDispatch();
        }
    }
}

