/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.ChannelId;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

public class ServerChannelImpl
implements ServerChannel {
    private final BayeuxServerImpl _bayeux;
    private final ServerChannelImpl _parent;
    private final ChannelId _id;
    private final Set<ServerSessionImpl> _subscribers = new CopyOnWriteArraySet<ServerSessionImpl>();
    private final List<ServerChannel.ServerChannelListener> _listeners = new CopyOnWriteArrayList<ServerChannel.ServerChannelListener>();
    private final ConcurrentMap<String, ServerChannelImpl> _children = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final boolean _meta;
    private final boolean _broadcast;
    private final boolean _service;
    private boolean _lazy;
    private boolean _persistent;
    private ServerChannelImpl _wild;
    private ServerChannelImpl _deepWild;
    private volatile boolean _used;

    protected ServerChannelImpl(BayeuxServerImpl bayeux, ServerChannelImpl parent, ChannelId id) {
        this._bayeux = bayeux;
        this._parent = parent;
        this._id = id;
        this._meta = this._id.isMeta();
        this._service = this._id.isService();
        this._broadcast = !this.isMeta() && !this.isService();
        this.setPersistent(!this._broadcast);
    }

    protected boolean subscribe(ServerSessionImpl session) {
        if (!session.isHandshook()) {
            return false;
        }
        this._subscribers.add(session);
        session.subscribedTo(this);
        for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
            if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
            ((ServerChannel.SubscriptionListener)serverChannelListener).subscribed((ServerSession)session, (ServerChannel)this);
        }
        for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
            if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
            ((BayeuxServer.SubscriptionListener)bayeuxServerListener).subscribed((ServerSession)session, (ServerChannel)this);
        }
        this._used = true;
        return true;
    }

    protected void unsubscribe(ServerSessionImpl session) {
        if (this._subscribers.remove(session)) {
            for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                ((ServerChannel.SubscriptionListener)serverChannelListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                ((BayeuxServer.SubscriptionListener)bayeuxServerListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
            if (!this.isPersistent() && this._subscribers.size() == 0 && this._children.size() == 0) {
                this.remove();
            }
        }
        session.unsubscribedTo(this);
    }

    public Set<? extends ServerSession> getSubscribers() {
        return this._subscribers;
    }

    public boolean isBroadcast() {
        return this._broadcast;
    }

    public boolean isDeepWild() {
        return this._id.isDeepWild();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public boolean isWild() {
        return this._id.isWild();
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public void addListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.add(listener);
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isMeta() {
        return this._meta;
    }

    public boolean isService() {
        return this._service;
    }

    public void removeListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.remove(listener);
    }

    public ServerChannelImpl getChild(ChannelId id, boolean create) {
        if (!this._id.isParentOf(id)) {
            if (create) {
                throw new IllegalArgumentException(this._id + " not parent of " + id);
            }
            return null;
        }
        String next = id.getSegment(this._id.depth());
        ServerChannelImpl child = (ServerChannelImpl)this._children.get(next);
        if (child == null) {
            if (!create) {
                return null;
            }
            String cid = (this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next;
            child = new ServerChannelImpl(this._bayeux, this, new ChannelId(cid));
            ServerChannelImpl old = this._children.putIfAbsent(next, child);
            if (old == null) {
                this._used = true;
                if ("*".equals(next)) {
                    this._wild = child;
                } else if ("**".equals(next)) {
                    this._deepWild = child;
                }
                this._bayeux.addServerChannel(child);
            } else {
                child = old;
            }
        }
        if (id.depth() - this._id.depth() > 1) {
            return child.getChild(id, create);
        }
        return child;
    }

    public void publish(Session from, ServerMessage msg) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerMessage.Mutable mutable = msg.asMutable();
        if (this._bayeux.extendSend(null, mutable)) {
            this._bayeux.root().doPublish((ServerSessionImpl)from, this, mutable);
        }
    }

    public void publish(Session from, Object data, Object id) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(this.getId());
        if (from != null) {
            mutable.setClientId(from.getId());
        }
        mutable.setData(data);
        mutable.setId(id);
        if (this._bayeux.extendSend(null, mutable)) {
            ServerSessionImpl session = (ServerSessionImpl)(from instanceof LocalSession ? ((LocalSession)from).getServerSession() : (ServerSession)from);
            this._bayeux.root().doPublish(session, this, mutable);
        }
    }

    void doPublish(ServerSessionImpl from, ServerChannelImpl to, ServerMessage.Mutable mutable) {
        int tail = to._id.depth() - this._id.depth();
        ServerChannelImpl wild = this._wild;
        ServerChannelImpl deepwild = this._deepWild;
        switch (tail) {
            case 0: {
                if (this.isLazy()) {
                    mutable.setLazy(true);
                }
                for (ServerChannel.ServerChannelListener listener : this._listeners) {
                    if (!(listener instanceof ServerChannel.MessageListener) || ((ServerChannel.MessageListener)listener).onMessage((ServerSession)from, (ServerChannel)to, mutable)) continue;
                    return;
                }
                this._bayeux.root().doSubscribers(from, to._id, mutable);
                if (!this.isMeta()) break;
                for (ServerChannel.ServerChannelListener listener : this._listeners) {
                    if (!(listener instanceof BayeuxServerImpl.HandlerListener)) continue;
                    ((BayeuxServerImpl.HandlerListener)listener).onMessage(from, mutable);
                }
                break;
            }
            case 1: {
                if (wild != null) {
                    if (wild.isLazy()) {
                        mutable.setLazy(true);
                    }
                    for (ServerChannel.ServerChannelListener listener : wild._listeners) {
                        if (!(listener instanceof ServerChannel.MessageListener) || ((ServerChannel.MessageListener)listener).onMessage((ServerSession)from, (ServerChannel)to, mutable)) continue;
                        return;
                    }
                }
            }
            default: {
                String next;
                ServerChannelImpl channel;
                if (deepwild != null) {
                    if (deepwild.isLazy()) {
                        mutable.setLazy(true);
                    }
                    for (ServerChannel.ServerChannelListener listener : deepwild._listeners) {
                        if (!(listener instanceof ServerChannel.MessageListener) || ((ServerChannel.MessageListener)listener).onMessage((ServerSession)from, (ServerChannel)to, mutable)) continue;
                        return;
                    }
                }
                if ((channel = (ServerChannelImpl)this._children.get(next = to._id.getSegment(this._id.depth()))) == null) break;
                channel.doPublish(from, to, mutable);
            }
        }
    }

    void doSubscribers(ServerSessionImpl from, ChannelId to, ServerMessage.Mutable mutable) {
        ServerMessage message = mutable.asImmutable();
        int tail = to.depth() - this._id.depth();
        ServerChannelImpl wild = this._wild;
        ServerChannelImpl deepwild = this._deepWild;
        switch (tail) {
            case 0: {
                for (ServerSessionImpl session : this._subscribers) {
                    session.doDeliver(from, message);
                }
                break;
            }
            case 1: {
                if (wild != null) {
                    for (ServerSessionImpl session : wild._subscribers) {
                        session.doDeliver(from, message);
                    }
                }
            }
            default: {
                String next;
                ServerChannelImpl channel;
                if (deepwild != null) {
                    for (ServerSessionImpl session : deepwild._subscribers) {
                        session.doDeliver(from, message);
                    }
                }
                if ((channel = (ServerChannelImpl)this._children.get(next = to.getSegment(this._id.depth()))) == null) break;
                channel.doSubscribers(from, to, mutable);
            }
        }
    }

    protected void doSweep() {
        for (ServerChannelImpl child : this._children.values()) {
            child.doSweep();
        }
        for (ServerSessionImpl session : this._subscribers) {
            if (session.isHandshook()) continue;
            this.unsubscribe(session);
        }
        if (this._used && !this.isPersistent() && this._subscribers.size() == 0 && this._children.size() == 0) {
            this.remove();
        }
    }

    public void remove() {
        for (ServerChannelImpl child : this._children.values()) {
            child.remove();
        }
        if (this._bayeux.removeServerChannel(this)) {
            if (this.isDeepWild() && this._parent._deepWild == this) {
                this._parent._deepWild = null;
            } else if (this.isWild() && this._parent._wild == this) {
                this._parent._wild = null;
            }
            if (this._parent._children.remove(this._id.getSegment(this._id.depth() - 1), this)) {
                for (ServerSessionImpl session : this._subscribers) {
                    this.unsubscribe(session);
                }
            }
        }
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append(this.isLazy() ? " lazy" : "");
        b.append('\n');
        int leaves = this._children.size() + this._subscribers.size() + this._listeners.size();
        int i = 0;
        for (ServerChannelImpl serverChannelImpl : this._children.values()) {
            b.append(indent);
            b.append(" +-");
            serverChannelImpl.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerSessionImpl serverSessionImpl : this._subscribers) {
            b.append(indent);
            b.append(" +-");
            serverSessionImpl.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(serverChannelListener);
            b.append('\n');
        }
    }

    public String toString() {
        return this._id.toString();
    }
}

