/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerTransport;
import org.cometd.server.transports.HttpTransport;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class ServerSessionImpl
implements ServerSession {
    private static final AtomicLong _idCount = new AtomicLong();
    private final BayeuxServerImpl _bayeux;
    private final Logger _logger;
    private final String _id;
    private final List<ServerSession.ServerSessionListener> _listeners = new CopyOnWriteArrayList<ServerSession.ServerSessionListener>();
    private final List<ServerSession.Extension> _extensions = new CopyOnWriteArrayList<ServerSession.Extension>();
    private final ArrayQueue<ServerMessage> _queue = new ArrayQueue(8, 16, (Object)this);
    private final AtomicInteger _batch = new AtomicInteger();
    private final LocalSessionImpl _localSession;
    private final AttributesMap _attributes = new AttributesMap();
    private final AtomicBoolean _connected = new AtomicBoolean();
    private final AtomicBoolean _handshook = new AtomicBoolean();
    private final Set<ServerChannelImpl> _subscribedTo = Collections.newSetFromMap(new ConcurrentHashMap());
    private ServerTransport.Dispatcher _dispatcher;
    private transient ServerTransport _advisedTransport;
    private int _maxQueue = -1;
    private long _timeout = -1L;
    private long _interval = -1L;
    private long _maxInterval;
    private long _maxLazy = -1L;
    private boolean _metaConnectDelivery;
    private long _accessed = -1L;
    private Timeout.Task _intervalTask;
    private boolean _lazyDispatch;
    private Timeout.Task _lazyTask;

    protected ServerSessionImpl(BayeuxServerImpl bayeux) {
        this(bayeux, null, null);
    }

    protected ServerSessionImpl(BayeuxServerImpl bayeux, LocalSessionImpl localSession, String idHint) {
        this._bayeux = bayeux;
        this._logger = bayeux.getLogger();
        this._localSession = localSession;
        StringBuilder id = new StringBuilder(30);
        int len = 20;
        if (idHint != null) {
            len += idHint.length() + 1;
            id.append(idHint);
            id.append('_');
        }
        int index = id.length();
        while (id.length() < len) {
            long random = this._bayeux.randomLong();
            id.append(Long.toString(random < 0L ? -random : random, 36));
        }
        id.insert(index, Long.toString(_idCount.incrementAndGet(), 36));
        this._id = id.toString();
        this._intervalTask = new Timeout.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void expired() {
                if (ServerSessionImpl.this._logger.isDebugEnabled()) {
                    ServerSessionImpl.this._logger.debug("Expired interval " + ServerSessionImpl.this);
                }
                ArrayQueue arrayQueue = ServerSessionImpl.this._queue;
                synchronized (arrayQueue) {
                    if (ServerSessionImpl.this._dispatcher != null) {
                        ServerSessionImpl.this._dispatcher.cancelDispatch();
                    }
                }
                ServerSessionImpl.this._bayeux.removeServerSession(ServerSessionImpl.this, true);
            }

            public String toString() {
                return "IntervalTask@" + ServerSessionImpl.this.getId();
            }
        };
        HttpTransport transport = (HttpTransport)this._bayeux.getCurrentTransport();
        if (transport != null) {
            this._bayeux.startTimeout(this._intervalTask, transport.getMaxInterval());
        }
    }

    protected List<ServerSession.Extension> getExtensions() {
        return this._extensions;
    }

    public void addExtension(ServerSession.Extension extension) {
        this._extensions.add(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Runnable batch) {
        try {
            this.startBatch();
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    public void deliver(Session from, ServerMessage message) {
        ServerMessage.Mutable mutable = message.asMutable();
        if (!this._bayeux.extendSend((ServerSessionImpl)from, mutable)) {
            return;
        }
        if (from instanceof LocalSession) {
            this.doDeliver(((LocalSession)from).getServerSession(), message);
        } else {
            this.doDeliver((ServerSession)from, message);
        }
    }

    public void deliver(Session from, String channelId, Object data, Object id) {
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(channelId);
        mutable.setData(data);
        mutable.setId(id);
        this.deliver(from, (ServerMessage)mutable);
    }

    protected void doDeliver(ServerSession from, ServerMessage message) {
        if ((message = this.extendSend(message)) == null) {
            return;
        }
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            try {
                if (listener instanceof ServerSession.MaxQueueListener && this._maxQueue >= 0 && this._queue.size() >= this._maxQueue && !((ServerSession.MaxQueueListener)listener).queueMaxed((ServerSession)this, (Session)from, (Message)message)) {
                    return;
                }
                if (!(listener instanceof ServerSession.MessageListener) || ((ServerSession.MessageListener)listener).onMessage((ServerSession)this, from, message)) continue;
                return;
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
        message.incRef();
        this._queue.add((Object)message);
        if (this._batch.get() == 0 && this._queue.size() > 0) {
            if (message.isLazy()) {
                this.dispatchLazy();
            } else {
                this.dispatch();
            }
        }
    }

    protected void handshake() {
        this._handshook.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(long timestamp) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            HttpTransport transport;
            this.cancelIntervalTimeout();
            this._connected.set(true);
            if (this._accessed == -1L && (transport = (HttpTransport)this._bayeux.getCurrentTransport()) != null) {
                this._maxQueue = transport.getOption("maxQueue", -1);
                this._maxInterval = this._interval >= 0L ? this._interval + transport.getMaxInterval() - transport.getInterval() : transport.getMaxInterval();
                this._maxLazy = transport.getMaxLazyTimeout();
                if (this._maxLazy > 0L) {
                    this._lazyTask = new Timeout.Task(){

                        public void expired() {
                            ServerSessionImpl.this.dispatch();
                        }

                        public String toString() {
                            return "LazyTask@" + ServerSessionImpl.this.getId();
                        }
                    };
                }
            }
            this._accessed = timestamp;
        }
    }

    public void disconnect() {
        boolean connected = this._bayeux.removeServerSession(this, false);
        if (connected) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.incRef();
            message.setClientId(this.getId());
            message.setChannel("/meta/disconnect");
            message.setSuccessful(true);
            this.deliver((Session)this, (ServerMessage)message);
            if (this._queue.size() > 0) {
                this.dispatch();
            }
        }
    }

    public void endBatch() {
        if (this._batch.decrementAndGet() == 0 && this._queue.size() > 0) {
            this.dispatch();
        }
    }

    public LocalSession getLocalSession() {
        return this._localSession;
    }

    public boolean isLocalSession() {
        return this._localSession != null;
    }

    public void startBatch() {
        this._batch.incrementAndGet();
    }

    public void addListener(ServerSession.ServerSessionListener listener) {
        this._listeners.add(listener);
    }

    public String getId() {
        return this._id;
    }

    public Queue<ServerMessage> getQueue() {
        return this._queue;
    }

    public void removeListener(ServerSession.ServerSessionListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDispatcher(ServerTransport.Dispatcher dispatcher) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (dispatcher == null) {
                ServerTransport.Dispatcher old = this._dispatcher;
                this._dispatcher = null;
                return old != null;
            }
            if (this._dispatcher != null && this._dispatcher != dispatcher) {
                throw new IllegalStateException();
            }
            if (this._queue.size() > 0) {
                return false;
            }
            this._dispatcher = dispatcher;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            ServerTransport.Dispatcher dispatcher;
            if (this._lazyDispatch && this._lazyTask != null) {
                this._bayeux.cancelTimeout(this._lazyTask);
            }
            if ((dispatcher = this._dispatcher) != null) {
                this._dispatcher = null;
                dispatcher.dispatch();
                return;
            }
        }
        if (this._localSession != null && this._queue.size() > 0) {
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                ((ServerSession.DeQueueListener)listener).deQueue((ServerSession)this);
            }
            int s = this._queue.size();
            while (s-- > 0) {
                ServerMessage msg = (ServerMessage)this._queue.poll();
                if (msg == null) continue;
                this._localSession.receive((Message)msg, (Message.Mutable)msg.asMutable());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLazy() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (this._maxLazy == 0L) {
                this.dispatch();
            } else if (this._maxLazy > 0L && !this._lazyDispatch) {
                this._lazyDispatch = true;
                this._bayeux.startTimeout(this._lazyTask, this._accessed % this._maxLazy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDispatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            ServerTransport.Dispatcher dispatcher = this._dispatcher;
            if (dispatcher != null) {
                this._dispatcher = null;
                dispatcher.cancelDispatch();
            }
        }
    }

    public void cancelIntervalTimeout() {
        this._bayeux.cancelTimeout(this._intervalTask);
    }

    public void startIntervalTimeout() {
        this._bayeux.startTimeout(this._intervalTask, this._maxInterval);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public boolean isConnected() {
        return this._connected.get();
    }

    public boolean isHandshook() {
        return this._handshook.get();
    }

    protected boolean extendRecv(ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.rcvMeta((ServerSession)this, message)) continue;
                return false;
            }
        } else {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.rcv((ServerSession)this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected ServerMessage extendSend(ServerMessage message) {
        if (message.isMeta()) {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.sendMeta((ServerSession)this, message.asMutable())) continue;
                return null;
            }
        } else {
            for (ServerSession.Extension ext : this._extensions) {
                message = ext.send((ServerSession)this, message);
                if (message != null) continue;
                return null;
            }
        }
        return message;
    }

    public Object getAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport == null) {
            return null;
        }
        return new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + (this._interval == -1L ? transport.getInterval() : this._interval) + ",\"timeout\":" + (this._timeout == -1L ? transport.getTimeout() : this._timeout) + "}");
    }

    public void reAdvise() {
        this._advisedTransport = null;
    }

    public Object takeAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport != null && transport != this._advisedTransport) {
            this._advisedTransport = transport;
            return this.getAdvice();
        }
        return null;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
        this._advisedTransport = null;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
        this._advisedTransport = null;
    }

    protected boolean removed(boolean timedout) {
        boolean connected = this._connected.getAndSet(false);
        boolean handshook = this._handshook.getAndSet(false);
        if (connected || handshook) {
            for (ServerChannelImpl channel : this._subscribedTo) {
                channel.unsubscribe(this);
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.RemoveListener)) continue;
                ((ServerSession.RemoveListener)listener).removed((ServerSession)this, timedout);
            }
        }
        return connected;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDelivery = meta;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDelivery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                ((ServerSession.DeQueueListener)listener).deQueue((ServerSession)this);
            }
        }
    }

    protected void subscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.add(channel);
    }

    protected void unsubscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.remove(channel);
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        for (ServerSession.ServerSessionListener child : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(child);
            b.append('\n');
        }
        if (this.isLocalSession()) {
            b.append(indent);
            b.append(" +-");
            this._localSession.dump(b, indent + "   ");
        }
    }

    public String toString() {
        return this._id;
    }
}

