/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transports;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ServerTransport;
import org.cometd.server.transports.HttpTransport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;

public abstract class LongPollingTransport
extends HttpTransport {
    private static final AtomicInteger __zero = new AtomicInteger(0);
    protected static final String BROWSER_ID_OPTION = "browserId";
    protected static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    protected static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    private final ConcurrentHashMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap();
    protected String _browserId = "BAYEUX_BROWSER";
    private int _maxSessionsPerBrowser = 1;
    private long _multiSessionInterval = 2000L;

    protected LongPollingTransport(BayeuxServerImpl bayeux, String name, Map<String, Object> options) {
        super(bayeux, name, options);
        this._prefix.add("long-polling");
        this.setOption(BROWSER_ID_OPTION, this._browserId);
        this.setOption(MAX_SESSIONS_PER_BROWSER_OPTION, this._maxSessionsPerBrowser);
        this.setOption(MULTI_SESSION_INTERVAL_OPTION, this._multiSessionInterval);
    }

    @Override
    protected void init() {
        super.init();
        this._browserId = this.getOption(BROWSER_ID_OPTION, this._browserId);
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, this._maxSessionsPerBrowser);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, this._multiSessionInterval);
    }

    protected String getBrowserId(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserId.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        String browser_id = Long.toHexString(request.getRemotePort()) + Long.toString(this._bayeux.randomLong(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(this._browserId, browser_id);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browser_id;
    }

    protected boolean incBrowserId(String browserId, HttpServletRequest request, ServerMessage reply) {
        AtomicInteger new_count;
        if (this._maxSessionsPerBrowser < 0) {
            return true;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, new_count = new AtomicInteger())) == null) {
            count = new_count;
        }
        if (count.incrementAndGet() > this._maxSessionsPerBrowser) {
            Map advice = reply.asMutable().getAdvice(true);
            advice.put("multiple-clients", Boolean.TRUE);
            if (this._multiSessionInterval > 0L) {
                advice.put("reconnect", "retry");
                advice.put("interval", this._multiSessionInterval);
            } else {
                advice.put("reconnect", "none");
            }
            count.decrementAndGet();
            return false;
        }
        return true;
    }

    protected void decBrowserId(String browserId) {
        AtomicInteger count = this._browserMap.get(browserId);
        if (count != null && count.decrementAndGet() == 0) {
            this._browserMap.remove(browserId, __zero);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LongPollDispatcher dispatcher = (LongPollDispatcher)request.getAttribute("dispatcher");
        if (dispatcher == null) {
            boolean batch = false;
            ServerSessionImpl session = null;
            try {
                ServerMessage.Mutable[] messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                PrintWriter writer2 = null;
                for (ServerMessage.Mutable message : messages) {
                    message.incRef();
                    if (session == null && (session = (ServerSessionImpl)this._bayeux.getSession(message.getClientId())) != null && !message.isMeta()) {
                        batch = true;
                        session.startBatch();
                    }
                    boolean was_connected = session != null && session.isConnected();
                    boolean connect = "/meta/connect".equals(message.getChannel());
                    ServerMessage reply = this._bayeux.handle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this._bayeux.getSession(reply.getClientId());
                        } else {
                            if (connect || !this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                                Queue<ServerMessage> queue;
                                Queue<ServerMessage> queue2 = queue = session.getQueue();
                                synchronized (queue2) {
                                    session.dequeue();
                                    int i = queue.size();
                                    while (i-- > 0) {
                                        ServerMessage m = queue.poll();
                                        writer2 = this.send(request, response, writer2, m);
                                    }
                                }
                            }
                            if (connect) {
                                if (was_connected && writer2 == null && reply.isSuccessful()) {
                                    session.cancelDispatch();
                                    String browserId = this.getBrowserId(request, response);
                                    if (this.incBrowserId(browserId, request, reply)) {
                                        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                                        long timeout = session.getTimeout();
                                        continuation.setTimeout(timeout == -1L ? this._timeout : timeout);
                                        continuation.suspend();
                                        dispatcher = new LongPollDispatcher(session, continuation, reply, browserId);
                                        if (session.setDispatcher(dispatcher)) {
                                            request.setAttribute("dispatcher", (Object)dispatcher);
                                            reply = null;
                                        } else {
                                            continuation.complete();
                                            dispatcher = null;
                                            if (session.isConnected()) {
                                                session.startIntervalTimeout();
                                            }
                                        }
                                    } else {
                                        session.reAdvise();
                                    }
                                } else if (session.isConnected()) {
                                    session.startIntervalTimeout();
                                }
                            }
                        }
                        if (reply != null && (reply = this._bayeux.extendReply(session, reply)) != null) {
                            writer2 = this.send(request, response, writer2, reply);
                        }
                    }
                    message.setAssociated(null);
                    message.decRef();
                }
                if (writer2 == null) return;
                this.complete(writer2);
                return;
            }
            finally {
                if (batch) {
                    session.endBatch();
                }
            }
        }
        ServerSessionImpl session = dispatcher.getSession();
        if (session.isConnected()) {
            session.startIntervalTimeout();
        }
        Queue<ServerMessage> queue = session.getQueue();
        PrintWriter writer = null;
        Queue<ServerMessage> writer2 = queue;
        synchronized (writer2) {
            session.dequeue();
            int i = queue.size();
            while (i-- > 0) {
                ServerMessage m = queue.poll();
                writer = this.send(request, response, writer, m);
            }
        }
        ServerMessage reply = dispatcher.getReply();
        reply = this._bayeux.extendReply(session, reply);
        writer = this.send(request, response, writer, reply);
        this.complete(writer);
    }

    protected abstract PrintWriter send(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3, ServerMessage var4) throws IOException;

    protected abstract void complete(PrintWriter var1) throws IOException;

    private class LongPollDispatcher
    implements ServerTransport.Dispatcher,
    ContinuationListener {
        private final ServerSessionImpl _session;
        private final Continuation _continuation;
        private final ServerMessage _reply;
        private final String _browserId;

        public LongPollDispatcher(ServerSessionImpl session, Continuation continuation, ServerMessage reply, String browserId) {
            this._session = session;
            this._continuation = continuation;
            this._continuation.addContinuationListener((ContinuationListener)this);
            this._reply = reply;
            reply.incRef();
            this._browserId = browserId;
        }

        @Override
        public void cancelDispatch() {
            if (this._continuation != null && this._continuation.isSuspended()) {
                try {
                    ((HttpServletResponse)this._continuation.getServletResponse()).sendError(503);
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                try {
                    this._continuation.complete();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        @Override
        public void dispatch() {
            this._continuation.resume();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public Continuation getContinuation() {
            return this._continuation;
        }

        public ServerMessage getReply() {
            return this._reply;
        }

        public void onComplete(Continuation continuation) {
            LongPollingTransport.this.decBrowserId(this._browserId);
        }

        public void onTimeout(Continuation continuation) {
            this._session.setDispatcher(null);
        }
    }
}

