/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.common.ChannelId;
import org.cometd.util.ImmutableHashMap;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.ajax.JSON;

public class ServerMessageImpl
extends AbstractMap<String, Object>
implements ServerMessage,
JSON.Generator {
    private final ImmutableHashMap<String, Object> _immutable = new NestedMap(16);
    private final MutableMessage _mutable;
    private volatile ServerMessage _associated;
    private volatile boolean _lazy = false;
    private volatile String _jsonString;
    private static StringMap __fieldStrings = new StringMap();
    private static StringMap __valueStrings = new StringMap();
    private static JSON __json = new JSON(){

        protected Map newMap() {
            return new ImmutableHashMap().asMutable();
        }

        protected String toString(char[] buffer, int offset, int length) {
            Map.Entry entry = __valueStrings.getEntry(buffer, offset, length);
            if (entry != null) {
                return (String)entry.getValue();
            }
            String s = new String(buffer, offset, length);
            return s;
        }
    };
    private static JSON __msgJSON = new JSON(){

        protected Map newMap() {
            return new ServerMessageImpl().asMutable();
        }

        protected String toString(char[] buffer, int offset, int length) {
            Map.Entry entry = __fieldStrings.getEntry(buffer, offset, length);
            if (entry != null) {
                return (String)entry.getValue();
            }
            String s = new String(buffer, offset, length);
            return s;
        }

        protected JSON contextFor(String field) {
            return __json;
        }
    };
    private static JSON __batchJSON = new JSON(){

        protected Map newMap() {
            return new ServerMessageImpl().asMutable();
        }

        protected Object[] newArray(int size) {
            return new ServerMessage.Mutable[size];
        }

        protected JSON contextFor(String field) {
            return __json;
        }

        protected JSON contextForArray() {
            return __msgJSON;
        }
    };

    public ServerMessageImpl() {
        __fieldStrings.put("advice", (Object)"advice");
        __fieldStrings.put("channel", (Object)"channel");
        __fieldStrings.put("clientId", (Object)"clientId");
        __fieldStrings.put("data", (Object)"data");
        __fieldStrings.put("error", (Object)"error");
        __fieldStrings.put("ext", (Object)"ext");
        __fieldStrings.put("id", (Object)"id");
        __fieldStrings.put("subscription", (Object)"subscription");
        __fieldStrings.put("successful", (Object)"successful");
        __fieldStrings.put("timestamp", (Object)"timestamp");
        __fieldStrings.put("transport", (Object)"transport");
        __fieldStrings.put("connectionType", (Object)"connectionType");
        __valueStrings.put("/meta/connect", (Object)"/meta/connect");
        __valueStrings.put("/meta/disconnect", (Object)"/meta/disconnect");
        __valueStrings.put("/meta/handshake", (Object)"/meta/handshake");
        __valueStrings.put("/meta/subscribe", (Object)"/meta/subscribe");
        __valueStrings.put("/meta/unsubscribe", (Object)"/meta/unsubscribe");
        __valueStrings.put("long-polling", (Object)"long-polling");
        this._mutable = new MutableMessage();
    }

    public ServerMessage.Mutable asMutable() {
        return this._mutable;
    }

    public void addJSON(Appendable buffer) {
        try {
            buffer.append(this.getJSON());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this._immutable.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._immutable.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._immutable.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this._immutable.get(key);
    }

    public Map<String, Object> getAdvice() {
        Object advice = this._mutable._advice.asImmutable().getValue();
        if (advice instanceof JSON.Literal) {
            return (Map)JSON.parse((String)advice.toString());
        }
        return (Map)advice;
    }

    public ServerMessage getAssociated() {
        return this._associated;
    }

    public String getChannel() {
        return (String)this._mutable._channel.getValue();
    }

    public String getClientId() {
        return (String)this._mutable._clientId.getValue();
    }

    public Object getData() {
        return this._mutable._data.asImmutable().getValue();
    }

    public Map<String, Object> getDataAsMap() {
        return (Map)this._mutable._data.asImmutable().getValue();
    }

    public Map<String, Object> getExt() {
        return (Map)this._mutable._ext.asImmutable().getValue();
    }

    public String getId() {
        Object id = this._mutable._id.getValue();
        return id == null ? null : id.toString();
    }

    public String getJSON() {
        if (this._jsonString == null) {
            StringBuilder buf = new StringBuilder(__msgJSON.getStringBufferSize());
            __msgJSON.appendMap((Appendable)buf, (Map)this);
            this._jsonString = buf.toString();
        }
        return this._jsonString;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isMeta() {
        return ChannelId.isMeta((String)((String)this._mutable._channel.getValue()));
    }

    public boolean isSuccessful() {
        Boolean bool = (Boolean)this.get("successful");
        return bool != null && bool != false;
    }

    public void setAssociated(ServerMessage associated) {
        this._associated = associated;
    }

    public void setData(Object data) {
        this._mutable._data.asImmutable().setValue(data);
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    @Override
    public int size() {
        return this._immutable.size();
    }

    @Override
    public String toString() {
        return "|" + this.getJSON() + "|";
    }

    public static void addConvertor(Class forClass, JSON.Convertor convertor) {
        __json.addConvertor(forClass, convertor);
    }

    public static void addConvertorFor(String name, JSON.Convertor convertor) {
        __json.addConvertorFor(name, convertor);
    }

    public static ServerMessage.Mutable[] parseMessages(Reader reader) throws IOException {
        JSON.ReaderSource source = new JSON.ReaderSource(reader);
        Object batch = __batchJSON.parse((JSON.Source)source);
        if (batch == null) {
            return new ServerMessage.Mutable[0];
        }
        if (batch.getClass().isArray()) {
            return (ServerMessage.Mutable[])batch;
        }
        return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
    }

    public static ServerMessage.Mutable[] parseMessages(String s) throws IOException {
        Object batch = __batchJSON.parse((JSON.Source)new JSON.StringSource(s));
        if (batch == null) {
            return new ServerMessage.Mutable[0];
        }
        if (batch.getClass().isArray()) {
            return (ServerMessage.Mutable[])batch;
        }
        return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
    }

    public static ServerMessage.Mutable parseMessage(String s) throws IOException {
        return (ServerMessage.Mutable)__msgJSON.parse((JSON.Source)new JSON.StringSource(s));
    }

    class NestedMap
    extends ImmutableHashMap<String, Object> {
        protected NestedMap() {
        }

        protected NestedMap(int size) {
            super(size);
        }

        protected void onChange(String key) throws UnsupportedOperationException {
            ServerMessageImpl.this._jsonString = null;
        }
    }

    class MutableMessage
    extends AbstractMap<String, Object>
    implements ServerMessage.Mutable {
        private final ImmutableHashMap.Mutable _mutable;
        private final ImmutableHashMap.MutableEntry<String, Object> _advice;
        private final ImmutableHashMap.MutableEntry<String, Object> _channel;
        private final ImmutableHashMap.MutableEntry<String, Object> _clientId;
        private final ImmutableHashMap.MutableEntry<String, Object> _data;
        private final ImmutableHashMap.MutableEntry<String, Object> _ext;
        private final ImmutableHashMap.MutableEntry<String, Object> _id;

        MutableMessage() {
            this._mutable = ServerMessageImpl.this._immutable.asMutable();
            this._advice = this._mutable.getEntryReference((Object)"advice");
            this._channel = this._mutable.getEntryReference((Object)"channel");
            this._clientId = this._mutable.getEntryReference((Object)"clientId");
            this._data = this._mutable.getEntryReference((Object)"data");
            this._ext = this._mutable.getEntryReference((Object)"ext");
            this._id = this._mutable.getEntryReference((Object)"id");
        }

        public ServerMessage.Mutable asMutable() {
            return this;
        }

        public ServerMessageImpl asImmutable() {
            return ServerMessageImpl.this;
        }

        @Override
        public void clear() {
            this.setAssociated(null);
            ServerMessageImpl.this._jsonString = null;
            ServerMessageImpl.this._lazy = false;
            super.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this._mutable.containsKey(key);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this._mutable.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this._mutable.get(key);
        }

        public Map<String, Object> getAdvice() {
            Object advice = this._advice.getValue();
            if (advice instanceof JSON.Literal) {
                advice = JSON.parse((String)advice.toString());
                this._advice.setValue(advice);
            }
            return (Map)advice;
        }

        public Map<String, Object> getDataAsMap() {
            Map data = (Map)this._data.getValue();
            return data;
        }

        public Map<String, Object> getDataAsMap(boolean create) {
            Map data = (Map)this._data.getValue();
            if (create && data == null) {
                data = new NestedMap(16).asMutable();
                this._data.setValue((Object)data);
            }
            return data;
        }

        public Map<String, Object> getAdvice(boolean create) {
            Object advice = this._advice.getValue();
            if (advice instanceof JSON.Literal) {
                advice = JSON.parse((String)advice.toString());
                this._advice.setValue(advice);
            }
            if (create && advice == null) {
                advice = new NestedMap(16).asMutable();
                this._advice.setValue(advice);
            }
            return (Map)advice;
        }

        public String getChannel() {
            return (String)this._channel.getValue();
        }

        public String getClientId() {
            return (String)this._clientId.getValue();
        }

        public Object getData() {
            return this._data.getValue();
        }

        public Map.Entry<String, Object> getEntry(String key) {
            return this._mutable.getEntry((Object)key);
        }

        public Map<String, Object> getExt() {
            return (Map)this._ext.getValue();
        }

        public Map<String, Object> getExt(boolean create) {
            Object ext = this._ext.getValue();
            if (ext == null && !create) {
                return null;
            }
            if (ext instanceof Map) {
                return (Map)ext;
            }
            if (ext instanceof JSON.Literal) {
                ext = __json.fromJSON(ext.toString());
                this._ext.setValue(ext);
                return (Map)ext;
            }
            ext = new NestedMap().asMutable();
            this._ext.setValue(ext);
            return (Map)ext;
        }

        public String getId() {
            Object id = this._id.getValue();
            return id == null ? null : id.toString();
        }

        public boolean isLazy() {
            return ServerMessageImpl.this._lazy;
        }

        public boolean isMeta() {
            return ChannelId.isMeta((String)((String)this._channel.getValue()));
        }

        @Override
        public Object put(String key, Object value) {
            return this._mutable.put((Object)key, value);
        }

        @Override
        public Object remove(Object key) {
            return this._mutable.remove(key);
        }

        public void setData(Object data) {
            this._data.setValue(data);
        }

        public void setLazy(boolean lazy) {
            ServerMessageImpl.this._lazy = lazy;
        }

        @Override
        public int size() {
            return this._mutable.size();
        }

        public ServerMessage getAssociated() {
            return ServerMessageImpl.this.getAssociated();
        }

        public void setAssociated(ServerMessage message) {
            ServerMessageImpl.this.setAssociated(message);
        }

        public void setClientId(String clientId) {
            this._clientId.setValue((Object)clientId);
        }

        public void setId(String id) {
            this._id.setValue((Object)id);
        }

        public void setChannel(String channel) {
            this._channel.setValue((Object)channel);
        }

        public String getJSON() {
            return ServerMessageImpl.this.getJSON();
        }

        public boolean isSuccessful() {
            return ServerMessageImpl.this.isSuccessful();
        }

        public void setSuccessful(boolean successful) {
            this.put("successful", (Object)(successful ? Boolean.TRUE : Boolean.FALSE));
        }

        @Override
        public String toString() {
            return this.getJSON();
        }
    }
}

