/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class ServerSessionImpl
implements ServerSession {
    private static final AtomicLong _idCount = new AtomicLong();
    private final BayeuxServerImpl _bayeux;
    private final Logger _logger;
    private final String _id;
    private final List<ServerSession.ServerSessionListener> _listeners = new CopyOnWriteArrayList<ServerSession.ServerSessionListener>();
    private final List<ServerSession.Extension> _extensions = new CopyOnWriteArrayList<ServerSession.Extension>();
    private final ArrayQueue<ServerMessage> _queue = new ArrayQueue(8, 16, (Object)this);
    private final LocalSessionImpl _localSession;
    private final AttributesMap _attributes = new AttributesMap();
    private final AtomicBoolean _connected = new AtomicBoolean();
    private final AtomicBoolean _handshook = new AtomicBoolean();
    private final Set<ServerChannelImpl> _subscribedTo = Collections.newSetFromMap(new ConcurrentHashMap());
    private AbstractServerTransport.Scheduler _scheduler;
    private ServerTransport _advisedTransport;
    private int _maxQueue = -1;
    private long _transientTimeout = -1L;
    private long _transientInterval = -1L;
    private long _timeout = -1L;
    private long _interval = -1L;
    private long _maxInterval;
    private long _maxLazy = -1L;
    private boolean _metaConnectDelivery;
    private int _batch;
    private String _userAgent;
    private long _connectTimestamp = -1L;
    private long _intervalTimestamp;
    private long _lastInterval;
    private long _lastConnect;
    private volatile boolean _lazyDispatch;
    private Timeout.Task _lazyTask;

    protected ServerSessionImpl(BayeuxServerImpl bayeux) {
        this(bayeux, null, null);
    }

    protected ServerSessionImpl(BayeuxServerImpl bayeux, LocalSessionImpl localSession, String idHint) {
        this._bayeux = bayeux;
        this._logger = bayeux.getLogger();
        this._localSession = localSession;
        StringBuilder id = new StringBuilder(30);
        int len = 20;
        if (idHint != null) {
            len += idHint.length() + 1;
            id.append(idHint);
            id.append('_');
        }
        int index = id.length();
        while (id.length() < len) {
            long random = this._bayeux.randomLong();
            id.append(Long.toString(random < 0L ? -random : random, 36));
        }
        id.insert(index, Long.toString(_idCount.incrementAndGet(), 36));
        this._id = id.toString();
        HttpTransport transport = (HttpTransport)this._bayeux.getCurrentTransport();
        if (transport != null) {
            this._intervalTimestamp = System.currentTimeMillis() + transport.getMaxInterval();
        }
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep(long now) {
        if (this._intervalTimestamp != 0L && now > this._intervalTimestamp) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Expired interval " + this, new Object[0]);
            }
            ArrayQueue<ServerMessage> arrayQueue = this._queue;
            synchronized (arrayQueue) {
                if (this._scheduler != null) {
                    this._scheduler.cancel();
                }
            }
            this._bayeux.removeServerSession(this, true);
        }
    }

    protected List<ServerSession.Extension> getExtensions() {
        return this._extensions;
    }

    public void addExtension(ServerSession.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(ServerSession.Extension extension) {
        this._extensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Runnable batch) {
        try {
            this.startBatch();
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    public void deliver(Session from, ServerMessage message) {
        ServerMessage.Mutable mutable = message.asMutable();
        if (!this._bayeux.extendSend((ServerSessionImpl)from, mutable)) {
            return;
        }
        if (from instanceof LocalSession) {
            this.doDeliver(((LocalSession)from).getServerSession(), message);
        } else {
            this.doDeliver((ServerSession)from, message);
        }
    }

    public void deliver(Session from, String channelId, Object data, String id) {
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(channelId);
        mutable.setData(data);
        mutable.setId(id);
        this.deliver(from, (ServerMessage)mutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeliver(ServerSession from, ServerMessage message) {
        boolean wakeup;
        if ((message = this.extendSend(message)) == null) {
            return;
        }
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            try {
                if (listener instanceof ServerSession.MaxQueueListener && this._maxQueue >= 0 && this._queue.size() >= this._maxQueue && !((ServerSession.MaxQueueListener)listener).queueMaxed((ServerSession)this, (Session)from, (Message)message)) {
                    return;
                }
                if (!(listener instanceof ServerSession.MessageListener) || ((ServerSession.MessageListener)listener).onMessage((ServerSession)this, from, message)) continue;
                return;
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.add((Object)message);
            wakeup = this._batch == 0;
        }
        if (wakeup) {
            if (message.isLazy()) {
                this.flushLazy();
            } else {
                this.flush();
            }
        }
    }

    protected void handshake() {
        this._handshook.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            HttpTransport transport;
            this._connected.set(true);
            if (this._connectTimestamp == -1L && (transport = (HttpTransport)this._bayeux.getCurrentTransport()) != null) {
                this._maxQueue = transport.getOption("maxQueue", -1);
                this._maxInterval = this._interval >= 0L ? this._interval + transport.getMaxInterval() - transport.getInterval() : transport.getMaxInterval();
                this._maxLazy = transport.getMaxLazyTimeout();
                if (this._maxLazy > 0L) {
                    this._lazyTask = new Timeout.Task(){

                        public void expired() {
                            ServerSessionImpl.this._lazyDispatch = false;
                            ServerSessionImpl.this.flush();
                        }

                        public String toString() {
                            return "LazyTask@" + ServerSessionImpl.this.getId();
                        }
                    };
                }
            }
            this.cancelIntervalTimeout();
        }
    }

    public void disconnect() {
        boolean connected = this._bayeux.removeServerSession(this, false);
        if (connected) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setClientId(this.getId());
            message.setChannel("/meta/disconnect");
            message.setSuccessful(true);
            this.deliver((Session)this, (ServerMessage)message);
            if (this._queue.size() > 0) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (--this._batch == 0 && this._queue.size() > 0) {
                this.flush();
            }
        }
    }

    public LocalSession getLocalSession() {
        return this._localSession;
    }

    public boolean isLocalSession() {
        return this._localSession != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            ++this._batch;
        }
    }

    public void addListener(ServerSession.ServerSessionListener listener) {
        this._listeners.add(listener);
    }

    public String getId() {
        return this._id;
    }

    public Object getLock() {
        return this._queue;
    }

    public Queue<ServerMessage> getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            return this._queue.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(ServerMessage message) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.add((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceQueue(List<ServerMessage> queue) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.clear();
            this._queue.addAll(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerMessage> takeQueue() {
        ArrayList<ServerMessage> copy;
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                ((ServerSession.DeQueueListener)listener).deQueue((ServerSession)this, this._queue);
            }
            copy = new ArrayList<ServerMessage>(this._queue.size() + 2);
            copy.addAll((Collection<ServerMessage>)this._queue);
            this._queue.clear();
        }
        return copy;
    }

    public void removeListener(ServerSession.ServerSessionListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(AbstractServerTransport.Scheduler scheduler) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (scheduler == null) {
                if (this._scheduler != null) {
                    this._scheduler.cancel();
                }
                this._scheduler = null;
            } else {
                if (this._scheduler != null && this._scheduler != scheduler) {
                    this._scheduler.cancel();
                }
                this._scheduler = scheduler;
                if (this._queue.size() > 0 && this._batch == 0) {
                    this._scheduler.schedule();
                    if (this._scheduler instanceof AbstractServerTransport.OneTimeScheduler) {
                        this._scheduler = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            AbstractServerTransport.Scheduler scheduler;
            if (this._lazyDispatch && this._lazyTask != null) {
                this._bayeux.cancelTimeout(this._lazyTask);
            }
            if ((scheduler = this._scheduler) != null) {
                if (this._scheduler instanceof AbstractServerTransport.OneTimeScheduler) {
                    this._scheduler = null;
                }
                scheduler.schedule();
                return;
            }
        }
        if (this._localSession != null && this._queue.size() > 0) {
            for (ServerMessage msg : this.takeQueue()) {
                if (msg == null) continue;
                this._localSession.receive((Message)msg, (Message.Mutable)msg.asMutable());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLazy() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (this._maxLazy == 0L) {
                this.flush();
            } else if (this._maxLazy > 0L && !this._lazyDispatch) {
                this._lazyDispatch = true;
                this._bayeux.startTimeout(this._lazyTask, this._connectTimestamp % this._maxLazy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSchedule() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            AbstractServerTransport.Scheduler dispatcher = this._scheduler;
            if (dispatcher != null) {
                this._scheduler = null;
                dispatcher.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntervalTimeout() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            long now = System.currentTimeMillis();
            if (this._intervalTimestamp > 0L) {
                this._lastInterval = now - (this._intervalTimestamp - this._maxInterval);
            }
            this._connectTimestamp = now;
            this._intervalTimestamp = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIntervalTimeout() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            long now = System.currentTimeMillis();
            this._lastConnect = now - this._connectTimestamp;
            this._intervalTimestamp = now + this._maxInterval;
        }
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public boolean isConnected() {
        return this._connected.get();
    }

    public boolean isHandshook() {
        return this._handshook.get();
    }

    protected boolean extendRecv(ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.rcvMeta((ServerSession)this, message)) continue;
                return false;
            }
        } else {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.rcv((ServerSession)this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected ServerMessage extendSend(ServerMessage message) {
        if (message.isMeta()) {
            for (ServerSession.Extension ext : this._extensions) {
                if (ext.sendMeta((ServerSession)this, message.asMutable())) continue;
                return null;
            }
        } else {
            for (ServerSession.Extension ext : this._extensions) {
                message = ext.send((ServerSession)this, message);
                if (message != null) continue;
                return null;
            }
        }
        return message;
    }

    public Object getAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport == null) {
            return null;
        }
        long timeout = this.getTimeout() < 0L ? transport.getTimeout() : this.getTimeout();
        long interval = this.getInterval() < 0L ? transport.getInterval() : this.getInterval();
        return new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + interval + "," + "\"timeout\":" + timeout + "}");
    }

    public void reAdvise() {
        this._advisedTransport = null;
    }

    public Object takeAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport != null && transport != this._advisedTransport) {
            this._advisedTransport = transport;
            return this.getAdvice();
        }
        return null;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
        this._advisedTransport = null;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
        this._advisedTransport = null;
    }

    protected boolean removed(boolean timedout) {
        boolean connected = this._connected.getAndSet(false);
        boolean handshook = this._handshook.getAndSet(false);
        if (connected || handshook) {
            for (ServerChannelImpl channel : this._subscribedTo) {
                channel.unsubscribe(this);
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.RemoveListener)) continue;
                ((ServerSession.RemoveListener)listener).removed((ServerSession)this, timedout);
            }
        }
        return connected;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDelivery = meta;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDelivery;
    }

    protected void subscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.add(channel);
    }

    protected void unsubscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.remove(channel);
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        for (ServerSession.ServerSessionListener child : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(child);
            b.append('\n');
        }
        if (this.isLocalSession()) {
            b.append(indent);
            b.append(" +-");
            this._localSession.dump(b, indent + "   ");
        }
    }

    public String toDetailString() {
        return this._id + ",lc=" + this._lastConnect + ",li=" + this._lastInterval;
    }

    public String toString() {
        return this._id;
    }

    public long calculateTimeout(long defaultTimeout) {
        if (this._transientTimeout >= 0L) {
            return this._transientTimeout;
        }
        if (this._timeout >= 0L) {
            return this._timeout;
        }
        return defaultTimeout;
    }

    public long calculateInterval(long defaultInterval) {
        if (this._transientInterval >= 0L) {
            return this._transientInterval;
        }
        if (this._interval >= 0L) {
            return this._interval;
        }
        return defaultInterval;
    }

    public void updateTransientTimeout(long timeout) {
        this._transientTimeout = this._transientTimeout >= 0L ? -1L : timeout;
    }

    public void updateTransientInterval(long interval) {
        this._transientInterval = this._transientInterval >= 0L ? -1L : interval;
    }
}

