/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AbstractClientSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSessionImpl
extends AbstractClientSession
implements LocalSession {
    private final Queue<ServerMessage.Mutable> _queue = new ConcurrentLinkedQueue<ServerMessage.Mutable>();
    private final Map<String, ClientSessionChannel.MessageListener> publishCallbacks = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final BayeuxServerImpl _bayeux;
    private final String _idHint;
    private ServerSessionImpl _session;

    protected LocalSessionImpl(BayeuxServerImpl bayeux, String idHint) {
        this._bayeux = bayeux;
        this._idHint = idHint;
    }

    public void receive(Message.Mutable message) {
        super.receive(message);
        if ("/meta/disconnect".equals(message.getChannel()) && message.isSuccessful()) {
            this._session = null;
        }
    }

    protected void notifyListeners(Message.Mutable message) {
        ClientSessionChannel.MessageListener listener;
        String messageId;
        if (message.isPublishReply() && (messageId = message.getId()) != null && (listener = this.publishCallbacks.remove(messageId)) != null) {
            this.notifyListener(listener, message);
        }
        super.notifyListeners(message);
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new LocalChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        return this._bayeux.newChannelId(channelId);
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            ServerMessage.Mutable message = this._queue.poll();
            this.doSend(this._session, message);
        }
    }

    public ServerSession getServerSession() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> template) {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        ServerSessionImpl session = new ServerSessionImpl(this._bayeux, this, this._idHint);
        ServerMessage.Mutable message = this._bayeux.newMessage();
        if (template != null) {
            message.putAll(template);
        }
        message.setChannel("/meta/handshake");
        this.doSend(session, message);
        ServerMessage.Mutable reply = message.getAssociated();
        if (reply != null && reply.isSuccessful()) {
            this._session = session;
            message = this._bayeux.newMessage();
            message.setChannel("/meta/connect");
            message.getAdvice(true).put("interval", -1L);
            message.setClientId(session.getId());
            this.doSend(session, message);
            reply = message.getAssociated();
            if (reply == null || !reply.isSuccessful()) {
                this._session = null;
            }
        }
    }

    public void disconnect() {
        if (this._session != null) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setChannel("/meta/disconnect");
            message.setClientId(this._session.getId());
            this.send(this._session, message);
            while (this.isBatching()) {
                this.endBatch();
            }
        }
    }

    public String getId() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session.getId();
    }

    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    public boolean isHandshook() {
        return this._session != null && this._session.isHandshook();
    }

    public String toString() {
        return "L:" + (this._session == null ? this._idHint + "?" : this._session.getId());
    }

    protected void send(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this.isBatching()) {
            this._queue.add(message);
        } else {
            this.doSend(session, message);
        }
    }

    protected void doSend(ServerSessionImpl from, ServerMessage.Mutable message) {
        String messageId = this.newMessageId();
        message.setId(messageId);
        ClientSessionChannel.MessageListener callback = (ClientSessionChannel.MessageListener)message.remove((Object)"org.cometd.client.publishCallback");
        if (!this.extendSend((Message.Mutable)message)) {
            return;
        }
        ServerMessage.Mutable reply = this._bayeux.handle(from, message);
        if (reply != null && (reply = this._bayeux.extendReply(from, this._session, reply)) != null) {
            if (callback != null) {
                this.publishCallbacks.put(messageId, callback);
            }
            this.receive((Message.Mutable)reply);
        }
    }

    protected class LocalChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected LocalChannel(ChannelId id) {
            super((AbstractClientSession)LocalSessionImpl.this, id);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return LocalSessionImpl.this;
        }

        public void publish(Object data, ClientSessionChannel.MessageListener listener) {
            this.throwIfReleased();
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel(this.getId());
            message.setData(data);
            message.setClientId(LocalSessionImpl.this.getId());
            if (listener != null) {
                message.put((Object)"org.cometd.client.publishCallback", (Object)listener);
            }
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
        }

        protected void sendSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this.getId());
            message.setClientId(LocalSessionImpl.this.getId());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
        }

        protected void sendUnSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this.getId());
            message.setClientId(LocalSessionImpl.this.getId());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
        }

        public String toString() {
            return super.toString() + "@" + LocalSessionImpl.this.toString();
        }
    }
}

