/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.LongPollingTransport;

public class JSONTransport
extends LongPollingTransport {
    public static final String PREFIX = "long-polling.json";
    public static final String NAME = "long-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    private boolean _jsonDebug = false;
    private String _mimeType = "application/json;charset=UTF-8";

    public JSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    protected boolean isAlwaysFlushingAfterHandle() {
        return false;
    }

    protected void init() {
        super.init();
        this._jsonDebug = this.getOption("jsonDebug", this._jsonDebug);
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
    }

    public boolean accept(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    protected ServerMessage.Mutable[] parseMessages(HttpServletRequest request) throws IOException, ParseException {
        String contentType;
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            request.setCharacterEncoding("UTF-8");
        }
        if ((contentType = request.getContentType()) == null || contentType.startsWith("application/json")) {
            return this.parseMessages(request.getReader(), this._jsonDebug);
        }
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            return this.parseMessages(request.getParameterValues("message"));
        }
        throw new IOException("Invalid Content-Type " + contentType);
    }

    protected ServletOutputStream beginWrite(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session) throws IOException {
        response.setContentType(this._mimeType);
        ServletOutputStream output = response.getOutputStream();
        output.write(91);
        return output;
    }

    protected void endWrite(ServletOutputStream output, ServerSessionImpl session) throws IOException {
        output.write(93);
        output.close();
    }
}

