/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpTransport
extends AbstractServerTransport {
    public static final String PREFIX = "long-polling";
    public static final String JSON_DEBUG_OPTION = "jsonDebug";
    public static final String MESSAGE_PARAM = "message";
    public static final String BROWSER_COOKIE_NAME_OPTION = "browserCookieName";
    public static final String BROWSER_COOKIE_DOMAIN_OPTION = "browserCookieDomain";
    public static final String BROWSER_COOKIE_PATH_OPTION = "browserCookiePath";
    public static final String BROWSER_COOKIE_SECURE_OPTION = "browserCookieSecure";
    public static final String BROWSER_COOKIE_HTTP_ONLY_OPTION = "browserCookieHttpOnly";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String HTTP2_MAX_SESSIONS_PER_BROWSER_OPTION = "http2MaxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String TRUST_CLIENT_SESSION = "trustClientSession";
    protected final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal();
    private final Map<String, Collection<ServerSessionImpl>> _sessions = new HashMap<String, Collection<ServerSessionImpl>>();
    private final ConcurrentMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> _browserSweep = new ConcurrentHashMap<String, AtomicInteger>();
    private String _browserCookieName;
    private String _browserCookieDomain;
    private String _browserCookiePath;
    private boolean _browserCookieSecure;
    private boolean _browserCookieHttpOnly;
    private int _maxSessionsPerBrowser;
    private int _http2MaxSessionsPerBrowser;
    private long _multiSessionInterval;
    private boolean _trustClientSession;
    private long _lastSweep;

    protected AbstractHttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public void init() {
        super.init();
        this._browserCookieName = this.getOption(BROWSER_COOKIE_NAME_OPTION, "BAYEUX_BROWSER");
        this._browserCookieDomain = this.getOption(BROWSER_COOKIE_DOMAIN_OPTION, null);
        this._browserCookiePath = this.getOption(BROWSER_COOKIE_PATH_OPTION, "/");
        this._browserCookieSecure = this.getOption(BROWSER_COOKIE_SECURE_OPTION, false);
        this._browserCookieHttpOnly = this.getOption(BROWSER_COOKIE_HTTP_ONLY_OPTION, true);
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, 1);
        this._http2MaxSessionsPerBrowser = this.getOption(HTTP2_MAX_SESSIONS_PER_BROWSER_OPTION, -1);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, 2000);
        this._trustClientSession = this.getOption(TRUST_CLIENT_SESSION, false);
    }

    protected long getMultiSessionInterval() {
        return this._multiSessionInterval;
    }

    public void setCurrentRequest(HttpServletRequest request) {
        this._currentRequest.set(request);
    }

    public HttpServletRequest getCurrentRequest() {
        return this._currentRequest.get();
    }

    public abstract boolean accept(HttpServletRequest var1);

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected abstract HttpScheduler suspend(HttpServletRequest var1, HttpServletResponse var2, ServerSessionImpl var3, ServerMessage.Mutable var4, long var5);

    protected abstract void write(HttpServletRequest var1, HttpServletResponse var2, ServerSessionImpl var3, boolean var4, List<ServerMessage> var5, ServerMessage.Mutable[] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessages(HttpServletRequest request, HttpServletResponse response, ServerMessage.Mutable[] messages) throws IOException {
        boolean batch;
        if (messages.length == 0) {
            throw new IOException();
        }
        Collection<ServerSessionImpl> sessions = this.findCurrentSessions(request);
        ServerMessage.Mutable message = messages[0];
        ServerSessionImpl session = this.findSession(sessions, message);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Processing {} messages for session {}", (Object)messages.length, (Object)session);
        }
        boolean bl = batch = session != null && !"/meta/connect".equals(message.getChannel());
        if (batch) {
            session.startBatch();
        }
        boolean sendQueue = false;
        boolean sendReplies = false;
        boolean scheduleExpiration = false;
        try {
            block11: for (int i = 0; i < messages.length; ++i) {
                message = messages[i];
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Processing {}", (Object)message);
                }
                switch (message.getChannel()) {
                    case "/meta/handshake": {
                        if (messages.length > 1) {
                            throw new IOException();
                        }
                        ServerMessage.Mutable reply = this.processMetaHandshake(request, response, session, message);
                        messages[i] = reply = this.processReply(session, reply);
                        sendQueue = this.allowMessageDeliveryDuringHandshake(session) && reply != null && reply.isSuccessful();
                        sendReplies = reply != null;
                        scheduleExpiration = true;
                        continue block11;
                    }
                    case "/meta/connect": {
                        boolean canSuspend = messages.length == 1;
                        ServerMessage.Mutable reply = this.processMetaConnect(request, response, session, message, canSuspend);
                        messages[i] = reply = this.processReply(session, reply);
                        sendReplies = sendQueue = !canSuspend || reply != null;
                        scheduleExpiration = true;
                        continue block11;
                    }
                    default: {
                        boolean metaConnectDelivery;
                        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
                        messages[i] = reply = this.processReply(session, reply);
                        boolean bl2 = metaConnectDelivery = this.isMetaConnectDeliveryOnly() || session != null && session.isMetaConnectDeliveryOnly();
                        if (!metaConnectDelivery) {
                            sendQueue = true;
                        }
                        if (reply == null) continue block11;
                        sendReplies = true;
                        continue block11;
                    }
                }
            }
            if (sendQueue || sendReplies) {
                this.flush(request, response, session, sendQueue, scheduleExpiration, messages);
            }
        }
        finally {
            if (batch) {
                session.endBatch();
            }
        }
    }

    protected ServerSessionImpl findSession(Collection<ServerSessionImpl> sessions, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel())) {
            ServerSessionImpl session = this.getBayeux().newServerSession();
            session.setAllowMessageDeliveryDuringHandshake(this.isAllowMessageDeliveryDuringHandshake());
            return session;
        }
        String clientId = message.getClientId();
        if (sessions != null && clientId != null) {
            for (ServerSessionImpl session : sessions) {
                if (!session.getId().equals(clientId)) continue;
                return session;
            }
        }
        if (this._trustClientSession) {
            return (ServerSessionImpl)this.getBayeux().getSession(clientId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ServerSessionImpl> findCurrentSessions(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserCookieName.equals(cookie.getName())) continue;
                Map<String, Collection<ServerSessionImpl>> map = this._sessions;
                synchronized (map) {
                    return this._sessions.get(cookie.getValue());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerMessage.Mutable processMetaHandshake(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
        if (reply.isSuccessful()) {
            String id = this.findBrowserId(request);
            if (id == null) {
                id = this.setBrowserId(request, response);
            }
            final String browserId = id;
            session.setBrowserId(browserId);
            Map<String, Collection<ServerSessionImpl>> map = this._sessions;
            synchronized (map) {
                Collection<ServerSessionImpl> sessions = this._sessions.get(browserId);
                if (sessions == null) {
                    sessions = new CopyOnWriteArrayList<ServerSessionImpl>();
                    this._sessions.put(browserId, sessions);
                }
                sessions.add(session);
            }
            session.addListener((ServerSession.ServerSessionListener)new ServerSession.RemoveListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void removed(ServerSession session, boolean timeout) {
                    Map map = AbstractHttpTransport.this._sessions;
                    synchronized (map) {
                        Collection sessions = (Collection)AbstractHttpTransport.this._sessions.get(browserId);
                        sessions.remove(session);
                        if (sessions.isEmpty()) {
                            AbstractHttpTransport.this._sessions.remove(browserId);
                        }
                    }
                }
            });
        }
        return reply;
    }

    protected ServerMessage.Mutable processMetaConnect(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable message, boolean canSuspend) {
        if (session != null) {
            session.setScheduler(null);
        }
        boolean wasConnected = session != null && session.isConnected();
        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
        if (session != null) {
            boolean maySuspend;
            boolean bl = maySuspend = !session.shouldSchedule();
            if (canSuspend && maySuspend && reply.isSuccessful()) {
                boolean allowSuspendConnect = this.incBrowserId(session, this.isHTTP2(request));
                if (allowSuspendConnect) {
                    long timeout = session.calculateTimeout(this.getTimeout());
                    if (timeout > 0L && wasConnected && session.isConnected()) {
                        HttpScheduler scheduler = this.suspend(request, response, session, reply, timeout);
                        this.metaConnectSuspended(request, response, scheduler.getAsyncContext(), session);
                        session.setScheduler(scheduler);
                        reply = null;
                    } else {
                        this.decBrowserId(session, this.isHTTP2(request));
                    }
                } else {
                    Map advice = reply.getAdvice(true);
                    advice.put("multiple-clients", true);
                    long multiSessionInterval = this.getMultiSessionInterval();
                    if (multiSessionInterval > 0L) {
                        advice.put("reconnect", "retry");
                        advice.put("interval", multiSessionInterval);
                    } else {
                        advice.put("reconnect", "none");
                        reply.setSuccessful(false);
                    }
                    session.reAdvise();
                }
            }
            if (reply != null && session.isDisconnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
        }
        return reply;
    }

    protected boolean isHTTP2(HttpServletRequest request) {
        return "HTTP/2.0".equals(request.getProtocol());
    }

    protected void flush(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, boolean sendQueue, boolean scheduleExpiration, ServerMessage.Mutable ... replies) {
        List<ServerMessage> messages = Collections.emptyList();
        if (sendQueue && session != null) {
            messages = session.takeQueue();
        }
        this.write(request, response, session, scheduleExpiration, messages, replies);
    }

    protected void resume(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply) {
        this.metaConnectResumed(request, response, asyncContext, session);
        Map<String, Object> advice = session.takeAdvice(this);
        if (advice != null) {
            reply.put((Object)"advice", advice);
        }
        if (session.isDisconnected()) {
            reply.getAdvice(true).put("reconnect", "none");
        }
        this.flush(request, response, session, true, true, this.processReply(session, reply));
    }

    public BayeuxContext getContext() {
        HttpServletRequest request = this.getCurrentRequest();
        if (request != null) {
            return new HttpContext(request);
        }
        return null;
    }

    protected String findBrowserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String setBrowserId(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 16) {
            builder.append(Long.toString(this.getBayeux().randomLong(), 36));
        }
        builder.setLength(16);
        String browserId = builder.toString();
        Cookie cookie = new Cookie(this._browserCookieName, browserId);
        if (this._browserCookieDomain != null) {
            cookie.setDomain(this._browserCookieDomain);
        }
        cookie.setPath(this._browserCookiePath);
        cookie.setSecure(this._browserCookieSecure);
        cookie.setHttpOnly(this._browserCookieHttpOnly);
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browserId;
    }

    protected boolean incBrowserId(ServerSessionImpl session, boolean http2) {
        int sessions;
        AtomicInteger newCount;
        int maxSessionsPerBrowser;
        int n = maxSessionsPerBrowser = http2 ? this._http2MaxSessionsPerBrowser : this._maxSessionsPerBrowser;
        if (maxSessionsPerBrowser < 0) {
            return true;
        }
        if (maxSessionsPerBrowser == 0) {
            return false;
        }
        String browserId = session.getBrowserId();
        AtomicInteger count = (AtomicInteger)this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, newCount = new AtomicInteger())) == null) {
            count = newCount;
        }
        if ((sessions = count.incrementAndGet()) == 1) {
            this._browserSweep.remove(browserId);
        }
        boolean result = true;
        if (sessions > maxSessionsPerBrowser) {
            sessions = count.decrementAndGet();
            result = false;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("> client {} {} sessions from {}", new Object[]{browserId, sessions, session});
        }
        return result;
    }

    protected void decBrowserId(ServerSessionImpl session, boolean http2) {
        int maxSessionsPerBrowser = http2 ? this._http2MaxSessionsPerBrowser : this._maxSessionsPerBrowser;
        String browserId = session.getBrowserId();
        if (maxSessionsPerBrowser <= 0 || browserId == null) {
            return;
        }
        int sessions = -1;
        AtomicInteger count = (AtomicInteger)this._browserMap.get(browserId);
        if (count != null) {
            sessions = count.decrementAndGet();
        }
        if (sessions == 0) {
            this._browserSweep.put(browserId, new AtomicInteger(0));
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("< client {} {} sessions for {}", new Object[]{browserId, sessions, session});
        }
    }

    protected void handleJSONParseException(HttpServletRequest request, HttpServletResponse response, String json, Throwable exception) throws IOException {
        this._logger.warn("Could not parse JSON: " + json, exception);
        response.setStatus(400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, int responseCode) {
        try {
            response.setStatus(responseCode);
        }
        catch (Exception x) {
            this._logger.trace("Could not send " + responseCode + " response", (Throwable)x);
        }
        finally {
            try {
                if (asyncContext != null) {
                    asyncContext.complete();
                }
            }
            catch (Exception x) {
                this._logger.trace("Could not complete " + responseCode + " response", (Throwable)x);
            }
        }
    }

    protected ServerMessage.Mutable bayeuxServerHandle(ServerSessionImpl session, ServerMessage.Mutable message) {
        return this.getBayeux().handle(session, message);
    }

    protected void metaConnectSuspended(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSession session) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Suspended request {}", (Object)request);
        }
    }

    protected void metaConnectResumed(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSession session) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Resumed request {}", (Object)request);
        }
    }

    @Override
    protected void sweep() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._lastSweep;
        if (this._lastSweep > 0L && elapsed > 0L) {
            int maxSweeps = (int)(2L * this.getMaxInterval() / elapsed);
            for (Map.Entry<String, AtomicInteger> entry : this._browserSweep.entrySet()) {
                String key;
                AtomicInteger count = entry.getValue();
                if (count == null || count.incrementAndGet() <= maxSweeps || this._browserSweep.remove(key = entry.getKey()) != count || ((AtomicInteger)this._browserMap.get(key)).get() != 0) continue;
                this._browserMap.remove(key);
                if (!this._logger.isDebugEnabled()) continue;
                this._logger.debug("Swept browserId {}", (Object)key);
            }
        }
        this._lastSweep = now;
    }

    protected abstract class LongPollScheduler
    implements Runnable,
    HttpScheduler,
    AsyncListener {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AsyncContext asyncContext;
        private final ServerSessionImpl session;
        private final ServerMessage.Mutable reply;
        private final Scheduler.Task task;
        private final AtomicBoolean cancel;

        protected LongPollScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
            this.request = request;
            this.response = response;
            this.asyncContext = asyncContext;
            this.session = session;
            this.reply = reply;
            asyncContext.addListener((AsyncListener)this);
            this.task = AbstractHttpTransport.this.getBayeux().schedule(this, timeout);
            this.cancel = new AtomicBoolean();
        }

        @Override
        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public AsyncContext getAsyncContext() {
            return this.asyncContext;
        }

        public ServerSessionImpl getServerSession() {
            return this.session;
        }

        public ServerMessage.Mutable getMetaConnectReply() {
            return this.reply;
        }

        @Override
        public void schedule() {
            if (this.cancelTimeout()) {
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Resuming /meta/connect after schedule");
                }
                this.resume();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelTimeout()) {
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Duplicate /meta/connect, cancelling {}", (Object)this.reply);
                }
                this.error(408);
            }
        }

        private boolean cancelTimeout() {
            boolean cancelled = this.cancel.compareAndSet(false, true);
            this.task.cancel();
            return cancelled;
        }

        @Override
        public void run() {
            if (this.cancelTimeout()) {
                this.session.setScheduler(null);
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Resuming /meta/connect after timeout");
                }
                this.resume();
            }
        }

        private void resume() {
            AbstractHttpTransport.this.decBrowserId(this.session, AbstractHttpTransport.this.isHTTP2(this.request));
            this.dispatch();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
            this.error(500);
        }

        protected abstract void dispatch();

        protected void error(int code) {
            AbstractHttpTransport.this.decBrowserId(this.session, AbstractHttpTransport.this.isHTTP2(this.request));
            AbstractHttpTransport.this.error(this.getRequest(), this.getResponse(), this.getAsyncContext(), code);
        }
    }

    public static interface HttpScheduler
    extends AbstractServerTransport.Scheduler {
        public HttpServletRequest getRequest();

        public HttpServletResponse getResponse();

        public AsyncContext getAsyncContext();
    }

    private static class HttpContext
    implements BayeuxContext {
        final HttpServletRequest _request;

        HttpContext(HttpServletRequest request) {
            this._request = request;
        }

        public Principal getUserPrincipal() {
            return this._request.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            return this._request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return new InetSocketAddress(this._request.getRemoteHost(), this._request.getRemotePort());
        }

        public InetSocketAddress getLocalAddress() {
            return new InetSocketAddress(this._request.getLocalName(), this._request.getLocalPort());
        }

        public String getHeader(String name) {
            return this._request.getHeader(name);
        }

        public List<String> getHeaderValues(String name) {
            return Collections.list(this._request.getHeaders(name));
        }

        public String getParameter(String name) {
            return this._request.getParameter(name);
        }

        public List<String> getParameterValues(String name) {
            return Arrays.asList(this._request.getParameterValues(name));
        }

        public String getCookie(String name) {
            Cookie[] cookies = this._request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!name.equals(c.getName())) continue;
                    return c.getValue();
                }
            }
            return null;
        }

        public String getHttpSessionId() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getId();
            }
            return null;
        }

        public Object getHttpSessionAttribute(String name) {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getAttribute(name);
            }
            return null;
        }

        public void setHttpSessionAttribute(String name, Object value) {
            HttpSession session = this._request.getSession(false);
            if (session == null) {
                throw new IllegalStateException("!session");
            }
            session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._request.getAttribute(name);
        }

        private ServletContext getServletContext() {
            HttpSession s = this._request.getSession(false);
            if (s != null) {
                return s.getServletContext();
            }
            s = this._request.getSession(true);
            ServletContext servletContext = s.getServletContext();
            s.invalidate();
            return servletContext;
        }

        public Object getContextAttribute(String name) {
            return this.getServletContext().getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        public String getURL() {
            StringBuffer url = this._request.getRequestURL();
            String query = this._request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            return url.toString();
        }

        public List<Locale> getLocales() {
            return Collections.list(this._request.getLocales());
        }
    }
}

