/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.ridgesModules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.ridgesModules.SOrderRelationAdderProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="OrderRelationAdderComponent", factory="PepperManipulatorComponentFactory")
public class OrderRelationAdder
extends PepperManipulatorImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)"OrderRelationAdder");

    public OrderRelationAdder() {
        this.setName("OrderRelationAdder");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-RidgesModules"));
        this.setDesc("The OrderRelationAdder connects tokens or spans via an order relation with each other. This manipulator can be customized to connect spans having a specific annotation or to connect all tokens. ");
        this.setProperties(new SOrderRelationAdderProperties());
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        SOrderRelationMapper mapper = new SOrderRelationMapper();
        return mapper;
    }

    public class SOrderRelationMapper
    extends PepperMapperImpl
    implements PepperMapper {
        /*
         * WARNING - void declaration
         */
        public DOCUMENT_STATUS mapSDocument() {
            SDocumentGraph graph = this.getDocument().getDocumentGraph();
            Hashtable<String, void> numOfCreatedSegmentations = new Hashtable<String, void>();
            if (((SOrderRelationAdderProperties)this.getProperties()).getSegmentations() == null || ((SOrderRelationAdderProperties)this.getProperties()).getSegmentations().size() == 0) {
                ArrayList<ImmutablePair> list;
                logger.debug("[{}] No annotation names are given to be used as segmentations, therefore order relations are added between tokens. ", (Object)OrderRelationAdder.this.getName());
                Hashtable<STextualDS, ArrayList<ImmutablePair>> maps = new Hashtable<STextualDS, ArrayList<ImmutablePair>>();
                for (STextualRelation rel : this.getDocument().getDocumentGraph().getTextualRelations()) {
                    STextualDS text = (STextualDS)rel.getTarget();
                    if (text == null) continue;
                    list = (ArrayList<ImmutablePair>)maps.get(text);
                    if (list == null) {
                        list = new ArrayList<ImmutablePair>();
                        maps.put(text, list);
                    }
                    list.add(new ImmutablePair((Object)rel.getStart(), (Object)rel.getSource()));
                }
                int numberOfAddedRels = 0;
                for (Map.Entry entry : maps.entrySet()) {
                    list = (List)entry.getValue();
                    STextualDS textDS = (STextualDS)entry.getKey();
                    String segName = textDS.getName();
                    Comparator<Pair<Integer, SToken>> comparator = new Comparator<Pair<Integer, SToken>>(){

                        @Override
                        public int compare(Pair<Integer, SToken> p1, Pair<Integer, SToken> p2) {
                            return (Integer)p1.getLeft() - (Integer)p2.getLeft();
                        }
                    };
                    Collections.sort(list, comparator);
                    SToken lastToken = null;
                    for (Pair pair : list) {
                        if (lastToken != null) {
                            SOrderRelation orderRel = SaltFactory.createSOrderRelation();
                            orderRel.setSource((Node)lastToken);
                            orderRel.setTarget((Node)pair.getRight());
                            if (segName != null) {
                                orderRel.setType(segName);
                            }
                            this.getDocument().getDocumentGraph().addRelation((Relation)orderRel);
                            ++numberOfAddedRels;
                        }
                        lastToken = (SToken)pair.getRight();
                    }
                }
                if (numberOfAddedRels == 0) {
                    logger.warn("[{}] Added no SOrderRelations for tokens. ", (Object)OrderRelationAdder.this.getName());
                } else {
                    logger.debug("[{}] Added '" + numberOfAddedRels + "' SOrderRelations to document '{}'. ", (Object)OrderRelationAdder.this.getName(), (Object)this.getDocument().getId());
                }
            } else {
                if (((SOrderRelationAdderProperties)this.getProperties()).getSegmentations() != null) {
                    int i = 0;
                    Hashtable segmentationSpans = new Hashtable();
                    String seg = null;
                    for (SSpan span : graph.getSpans()) {
                        block4: for (SAnnotation anno : span.getAnnotations()) {
                            if (!((SOrderRelationAdderProperties)this.getProperties()).getSegmentations().contains(anno.getName())) continue;
                            seg = anno.getName();
                            List overlapped = graph.getOverlappedDataSourceSequence((SNode)span, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
                            if (overlapped == null) continue;
                            for (DataSourceSequence o : overlapped) {
                                void var13_26;
                                if (!(o.getDataSource() instanceof STextualDS)) continue;
                                TreeMap treeMap = (TreeMap)segmentationSpans.get(seg);
                                if (treeMap == null) {
                                    TreeMap treeMap2 = new TreeMap();
                                    segmentationSpans.put(seg, treeMap2);
                                }
                                var13_26.put((Integer)o.getStart(), span);
                                continue block4;
                            }
                        }
                    }
                    for (String key : segmentationSpans.keySet()) {
                        TreeMap orderedSpans = (TreeMap)segmentationSpans.get(key);
                        SSpan lastSpan = null;
                        if (orderedSpans.values().size() == 0) {
                            logger.warn("[{}] Cannot add any SOrderRelation, because no span was found having one of the following annotations '{}'.", (Object)OrderRelationAdder.this.getName(), ((SOrderRelationAdderProperties)this.getProperties()).getSegmentations());
                        } else {
                            for (SSpan span : orderedSpans.values()) {
                                if (lastSpan != null) {
                                    void var13_33;
                                    SOrderRelation orderRel = SaltFactory.createSOrderRelation();
                                    orderRel.setSource((Node)lastSpan);
                                    orderRel.setTarget((Node)span);
                                    orderRel.setType(key);
                                    graph.addRelation((Relation)orderRel);
                                    Integer n = 1;
                                    if (numOfCreatedSegmentations.containsKey(key)) {
                                        Integer n2;
                                        Integer n3;
                                        Integer n4 = n3 = (Integer)numOfCreatedSegmentations.get(key);
                                        Integer n5 = n2 = Integer.valueOf(n3 + 1);
                                    }
                                    numOfCreatedSegmentations.put(key, var13_33);
                                }
                                lastSpan = span;
                            }
                        }
                        this.setProgress(new Double(++i / this.getDocument().getDocumentGraph().getSpans().size()));
                    }
                }
                if (numOfCreatedSegmentations.size() == 0) {
                    logger.warn("[{}] Added no SOrderRelations for segmentations {}. ", (Object)OrderRelationAdder.this.getName(), ((SOrderRelationAdderProperties)this.getProperties()).getSegmentations());
                } else if (logger.isDebugEnabled()) {
                    StringBuilder str = new StringBuilder();
                    str.append("[" + OrderRelationAdder.this.getName() + "] report creation of segmentations: \n");
                    for (String key : numOfCreatedSegmentations.keySet()) {
                        str.append("\t - Added ");
                        str.append(numOfCreatedSegmentations.get(key));
                        str.append(" SOrderRelations (segmentations) for '");
                        str.append(key);
                        str.append("'.\n");
                    }
                    logger.debug(str.toString());
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

