/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.toolboxModules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="WolofGlosserComponent", factory="PepperManipulatorComponentFactory")
public class WolofGlosser
extends PepperManipulatorImpl {
    public static final String FILE_GLOSSAR = "glossar.tab";
    public Map<String, String> glossar = new Hashtable<String, String>();
    public Map<String, String> posTags = new Hashtable<String, String>();
    public int numOfWords = 0;

    public WolofGlosser() {
        this.setName("WolofGlosser");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-ModuleBox"));
        this.setDesc("The WolofGlosser is a manipulator to create english glosses for a text written in wolof. ");
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        block19: {
            File glossarFile = new File(this.getResources().appendSegment(FILE_GLOSSAR).toFileString());
            if (glossarFile.exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(glossarFile));){
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        line = br.readLine();
                        if (line == null) continue;
                        String[] parts = line.split("\t");
                        int numOfBlanks = StringUtils.countMatches((CharSequence)parts[0], (CharSequence)" ");
                        if (this.numOfWords < numOfBlanks) {
                            this.numOfWords = numOfBlanks;
                        }
                        if (parts.length == 3) {
                            this.posTags.put(parts[0], parts[1]);
                            this.glossar.put(parts[0], parts[2]);
                            continue;
                        }
                        if (parts.length == 2) {
                            this.glossar.put(parts[0], parts[1]);
                            continue;
                        }
                        this.logger.warn("Ignore glossar file entry '" + line + "' in file '" + glossarFile.getAbsolutePath() + "', because it has '" + parts.length + "' columns instead of '2' or '3'. ");
                    }
                    break block19;
                }
                catch (IOException e) {
                    throw new PepperModuleException((PepperModule)this, "Cannot read the glossar file '" + glossarFile.getAbsolutePath() + "'. ", (Throwable)e);
                }
            }
            this.logger.warn("Cannot gloss texts, because the glossar file '" + glossarFile.getAbsolutePath() + "' does not exist. ");
        }
        return true;
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        GlossarMapper mapper = new GlossarMapper();
        mapper.glossar = this.glossar;
        mapper.posTags = this.posTags;
        mapper.numOfWords = this.numOfWords;
        return mapper;
    }

    public static class GlossarMapper
    extends PepperMapperImpl {
        public Map<String, String> glossar = new Hashtable<String, String>();
        public Map<String, String> posTags = new Hashtable<String, String>();
        public int numOfWords = 0;

        public DOCUMENT_STATUS mapSDocument() {
            if (this.getDocument().getDocumentGraph() != null && this.getDocument().getDocumentGraph().getTokens().size() > 0) {
                for (SToken tok : this.getDocument().getDocumentGraph().getTokens()) {
                    String pos;
                    String text = this.getDocument().getDocumentGraph().getText((SNode)tok);
                    String gloss = this.glossar.get(text);
                    if (gloss != null) {
                        tok.createAnnotation(null, "gloss", (Object)gloss);
                    }
                    if ((pos = this.posTags.get(text)) == null) continue;
                    tok.createAnnotation(null, "pos_gloss", (Object)pos);
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

