/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.toolboxModules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

@Component(name="WolofImporterComponent", factory="PepperImporterComponentFactory")
public class WolofImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final Logger logger = LoggerFactory.getLogger(WolofImporter.class);

    public WolofImporter() {
        this.setName("WolofImporter");
        this.setVersion("0.0.1");
        this.setDesc("This importer transforms data of an unknown format to salt. ");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-ModuleBox"));
        this.addSupportedFormat("xml", "1.0", null);
        this.getDocumentEndings().add("xml");
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        PepperMapperImpl mapper = new PepperMapperImpl(){

            public DOCUMENT_STATUS mapSDocument() {
                DocumentStructureReader contentHandler = new DocumentStructureReader();
                contentHandler.structure = this.getDocument().getDocumentGraph();
                this.readXMLResource(contentHandler, this.getResourceURI());
                return DOCUMENT_STATUS.COMPLETED;
            }
        };
        if (sElementId.getIdentifiableElement() != null && sElementId.getIdentifiableElement() instanceof SDocument) {
            URI resource = (URI)this.getIdentifier2ResourceTable().get(sElementId);
            mapper.setResourceURI(resource);
        }
        return mapper;
    }

    public class DocumentStructureReader
    extends DefaultHandler2 {
        public static final String TAG_ARTICLE = "article";
        public static final String TAG_SENTENCE = "s";
        public static final String TAG_WOL = "wol";
        public static final String TAG_EN = "en";
        public SDocumentGraph structure = null;
        private StringBuilder currentText = new StringBuilder();
        STextualDS primaryText = null;
        List<SToken> currentTokList = new ArrayList<SToken>();
        List<SToken> articleTokList = new ArrayList<SToken>();
        Set<SAnnotation> annoList = new HashSet<SAnnotation>();
        HashMap<String, String> annoListForSegmentElem = new HashMap();
        List<String> annosToAssociateWithWholeSegmentList = new ArrayList<String>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentText = new StringBuilder();
            if (TAG_WOL.equals(qName)) {
                this.currentTokList = new ArrayList<SToken>();
            } else if (TAG_ARTICLE.equals(qName)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    SAnnotation anno = SaltFactory.createSAnnotation();
                    anno.setName(attributes.getQName(i));
                    anno.setValue((Object)attributes.getValue(i));
                    this.annoList.add(anno);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (int i = start; i < start + length; ++i) {
                this.currentText.append(ch[i]);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (TAG_WOL.equals(qName)) {
                if (this.primaryText == null) {
                    this.primaryText = SaltFactory.createSTextualDS();
                    this.primaryText.setText("");
                    this.structure.addNode((Node)this.primaryText);
                }
                String text = this.currentText.toString();
                Tokenizer tokenizer = new Tokenizer();
                List tokenList = tokenizer.tokenizeToString(this.currentText.toString(), null);
                int offset = this.primaryText.getText().length();
                this.primaryText.setText(this.primaryText.getText() + text);
                for (String tok : tokenList) {
                    int currentPos = text.indexOf(tok);
                    int start = offset + currentPos;
                    int end = start + tok.length();
                    offset += tok.length() + currentPos;
                    text = text.substring(currentPos + tok.length());
                    SToken currTok = this.structure.createToken((SSequentialDS)this.primaryText, Integer.valueOf(start), Integer.valueOf(end));
                    this.currentTokList.add(currTok);
                }
                for (SToken curTok : this.currentTokList) {
                    this.articleTokList.add(curTok);
                }
            } else if (TAG_SENTENCE.equals(qName)) {
                this.currentTokList.clear();
            } else if (TAG_EN.equals(qName)) {
                SSpan span = this.structure.createSpan(this.currentTokList);
                span.createAnnotation(null, TAG_EN, (Object)this.currentText.toString());
                span.createAnnotation(null, "sentence", (Object)"sentence");
            } else if (TAG_ARTICLE.equals(qName)) {
                SSpan article = this.structure.createSpan(this.articleTokList);
                for (SAnnotation anno : this.annoList) {
                    article.addAnnotation(anno);
                }
                this.annoList.clear();
                this.articleTokList.clear();
            }
            this.currentText = new StringBuilder();
        }
    }
}

