/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.common;

import java.util.concurrent.ConcurrentHashMap;
import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.ConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumerFactory
implements ConsumerFactory {
    protected Logger logger = LoggerFactory.getLogger(MessageConsumerFactory.class);
    private static MessageConsumerFactory instance;
    private Consumer<?>[] consumers;
    private ConcurrentHashMap<String, Consumer<?>> consumerCache = new ConcurrentHashMap();

    public void setConsumers(Consumer<?>[] consumers) {
        this.consumers = consumers;
    }

    private MessageConsumerFactory() {
    }

    public static synchronized ConsumerFactory getInstance() {
        if (instance == null) {
            instance = new MessageConsumerFactory();
        }
        return instance;
    }

    @Override
    public <T> void addConsumer(Consumer<T> consumer) throws MQException {
        this.consumerCache.put(consumer.getConsumerKey(), consumer);
        this.logger.debug("Add Consumer : " + consumer.getConsumerKey());
    }

    @Override
    public <T> Consumer<T> getConsumer(String consumerKey) throws MQException {
        if (this.consumerCache.containsKey(consumerKey)) {
            this.logger.debug("Get Consumer : " + consumerKey);
            return this.consumerCache.get(consumerKey);
        }
        this.logger.warn("Unknown ConsumerKey : " + consumerKey);
        return null;
    }

    @Override
    public void init() throws MQException {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumerCache.put(this.consumers[i].getConsumerKey(), this.consumers[i]);
            }
        }
        this.logger.debug("Initialized!");
    }

    @Override
    public void destroy() throws MQException {
        if (this.consumers != null) {
            this.consumers = null;
        }
        if (instance != null) {
            instance = null;
        }
        if (this.consumerCache != null) {
            this.consumerCache.clear();
        }
        this.logger.debug("Destroyed!");
    }
}

