/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.common;

import java.util.concurrent.ConcurrentHashMap;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.ProducerFactory;
import org.darkphoenixs.mq.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProducerFactory
implements ProducerFactory {
    protected Logger logger = LoggerFactory.getLogger(MessageProducerFactory.class);
    private static MessageProducerFactory instance;
    private Producer<?>[] producers;
    private ConcurrentHashMap<String, Producer<?>> producerCache = new ConcurrentHashMap();

    public void setProducers(Producer<?>[] producers) {
        this.producers = producers;
    }

    private MessageProducerFactory() {
    }

    public static synchronized ProducerFactory getInstance() {
        if (instance == null) {
            instance = new MessageProducerFactory();
        }
        return instance;
    }

    @Override
    public <T> void addProducer(Producer<T> producer) throws MQException {
        this.producerCache.put(producer.getProducerKey(), producer);
        this.logger.debug("Add Producer : " + producer.getProducerKey());
    }

    @Override
    public <T> Producer<T> getProducer(String producerKey) throws MQException {
        if (this.producerCache.containsKey(producerKey)) {
            this.logger.debug("Get Producer : " + producerKey);
            return this.producerCache.get(producerKey);
        }
        this.logger.warn("Unknown ProducerKey : " + producerKey);
        return null;
    }

    @Override
    public void init() throws MQException {
        if (this.producers != null) {
            for (int i = 0; i < this.producers.length; ++i) {
                this.producerCache.put(this.producers[i].getProducerKey(), this.producers[i]);
            }
        }
    }

    @Override
    public void destroy() throws MQException {
        if (this.producers != null) {
            this.producers = null;
        }
        if (instance != null) {
            instance = null;
        }
        if (this.producerCache != null) {
            this.producerCache.clear();
        }
        this.logger.debug("Destroyed!");
    }
}

