/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.listener;

import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.ConsumerFactory;
import org.darkphoenixs.mq.listener.MessageListener;
import org.darkphoenixs.mq.util.RefleTool;

public class MessageFactoryConsumerListener<T>
implements MessageListener<T> {
    private String consumerKeyField;
    private ConsumerFactory consumerFactory;

    public String getConsumerKeyField() {
        return this.consumerKeyField;
    }

    public void setConsumerKeyField(String consumerKeyField) {
        this.consumerKeyField = consumerKeyField;
    }

    public ConsumerFactory getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setConsumerFactory(ConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    @Override
    public void onMessage(T message) throws MQException {
        if (this.consumerFactory == null) {
            throw new MQException("ConsumerFactory is null !");
        }
        if (this.consumerKeyField == null) {
            throw new MQException("ConsumerKeyField is null !");
        }
        if (message == null) {
            throw new MQException("Message is null !");
        }
        String consumerKey = RefleTool.getFieldValue(message, this.consumerKeyField, String.class);
        if (consumerKey == null) {
            throw new MQException("Consumer Key is null !");
        }
        Consumer<T> consumer = this.consumerFactory.getConsumer(consumerKey);
        if (consumer == null) {
            throw new MQException("Consumer is null !");
        }
        consumer.receive(message);
    }
}

