/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.producer;

import org.darkphoenixs.kafka.core.KafkaDestination;
import org.darkphoenixs.kafka.core.KafkaMessageTemplate;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer<T>
implements Producer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private KafkaMessageTemplate<T> messageTemplate;
    private KafkaDestination destination;

    public KafkaMessageTemplate<T> getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(KafkaMessageTemplate<T> messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public KafkaDestination getDestination() {
        return this.destination;
    }

    public void setDestination(KafkaDestination destination) {
        this.destination = destination;
    }

    @Override
    public void send(T message) throws MQException {
        try {
            T obj = this.doSend(message);
            this.messageTemplate.convertAndSend(this.destination, obj);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Send Success, ProducerKey : " + this.getProducerKey() + " , Message : " + message);
    }

    @Override
    public String getProducerKey() throws MQException {
        return this.destination.getDestinationName();
    }

    protected abstract T doSend(T var1) throws MQException;
}

