/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.darkphoenixs.kafka.core.KafkaMessageSender;
import org.darkphoenixs.kafka.pool.KafkaMessageSenderPool;

public class KafkaMessageSenderImpl<K, V>
implements KafkaMessageSender<K, V> {
    private Producer<K, V> producer;
    private KafkaMessageSenderPool<K, V> pool;

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void setProducer(Producer<K, V> producer) {
        this.producer = producer;
    }

    public KafkaMessageSenderPool<K, V> getPool() {
        return this.pool;
    }

    public void setPool(KafkaMessageSenderPool<K, V> pool) {
        this.pool = pool;
    }

    public KafkaMessageSenderImpl(Properties props, KafkaMessageSenderPool<K, V> pool) {
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
        this.pool = pool;
    }

    @Override
    public void send(String topic, V value) {
        KeyedMessage data = new KeyedMessage(topic, value);
        this.producer.send(data);
    }

    @Override
    public void sendWithKey(String topic, K key, V value) {
        KeyedMessage data = new KeyedMessage(topic, key, value);
        this.producer.send(data);
    }

    @Override
    public void close() {
        this.pool.returnSender(this);
    }

    @Override
    public void shutDown() {
        this.producer.close();
    }
}

