/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.List;
import org.darkphoenixs.kafka.core.KafkaDestination;
import org.darkphoenixs.kafka.core.KafkaMessageReceiver;
import org.darkphoenixs.kafka.core.KafkaMessageSender;
import org.darkphoenixs.kafka.pool.KafkaMessageReceiverPool;
import org.darkphoenixs.kafka.pool.KafkaMessageSenderPool;
import org.darkphoenixs.mq.codec.MessageDecoder;
import org.darkphoenixs.mq.codec.MessageEncoder;
import org.darkphoenixs.mq.exception.MQException;

public class KafkaMessageTemplate<T> {
    private KafkaMessageSenderPool<byte[], byte[]> messageSenderPool;
    private KafkaMessageReceiverPool<byte[], byte[]> messageReceiverPool;
    private MessageEncoder<T> encoder;
    private MessageDecoder<T> decoder;

    public void setMessageSenderPool(KafkaMessageSenderPool<byte[], byte[]> messageSenderPool) {
        this.messageSenderPool = messageSenderPool;
    }

    public KafkaMessageSenderPool<byte[], byte[]> getMessageSenderPool() {
        return this.messageSenderPool;
    }

    public KafkaMessageReceiverPool<byte[], byte[]> getMessageReceiverPool() {
        return this.messageReceiverPool;
    }

    public void setMessageReceiverPool(KafkaMessageReceiverPool<byte[], byte[]> messageReceiverPool) {
        this.messageReceiverPool = messageReceiverPool;
    }

    public void setEncoder(MessageEncoder<T> encoder) {
        this.encoder = encoder;
    }

    public MessageEncoder<T> getEncoder() {
        return this.encoder;
    }

    public MessageDecoder<T> getDecoder() {
        return this.decoder;
    }

    public void setDecoder(MessageDecoder<T> decoder) {
        this.decoder = decoder;
    }

    public void send(KafkaDestination destination, byte[] message) throws MQException {
        KafkaMessageSender<byte[], byte[]> sender = this.messageSenderPool.getSender(2000L);
        sender.send(destination.getDestinationName(), message);
        sender.close();
    }

    public void convertAndSend(KafkaDestination destination, T message) throws MQException {
        byte[] encoded = this.encoder.encode(message);
        this.send(destination, encoded);
    }

    public List<byte[]> receive(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        KafkaMessageReceiver<byte[], byte[]> receiver = this.messageReceiverPool.getReceiver();
        List<byte[]> messages = receiver.receive(destination.getDestinationName(), partition, beginOffset, readOffset);
        receiver.close();
        return messages;
    }

    public List<T> receiveAndConvert(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        List<byte[]> decoded = this.receive(destination, partition, beginOffset, readOffset);
        return this.decoder.batchDecode(decoded);
    }
}

