/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.List;
import java.util.Map;
import org.darkphoenixs.kafka.codec.KafkaMessageDecoder;
import org.darkphoenixs.kafka.codec.KafkaMessageEncoder;
import org.darkphoenixs.kafka.core.KafkaDestination;
import org.darkphoenixs.kafka.core.KafkaMessageReceiver;
import org.darkphoenixs.kafka.core.KafkaMessageSender;
import org.darkphoenixs.kafka.pool.KafkaMessageReceiverPool;
import org.darkphoenixs.kafka.pool.KafkaMessageSenderPool;
import org.darkphoenixs.kafka.pool.MessageReceiverPool;
import org.darkphoenixs.kafka.pool.MessageSenderPool;
import org.darkphoenixs.mq.exception.MQException;

public class KafkaMessageTemplate<K, V> {
    private MessageSenderPool<byte[], byte[]> messageSenderPool;
    private MessageReceiverPool<byte[], byte[]> messageReceiverPool;
    private KafkaMessageEncoder<K, V> encoder;
    private KafkaMessageDecoder<K, V> decoder;

    public void setMessageSenderPool(KafkaMessageSenderPool<byte[], byte[]> messageSenderPool) {
        this.messageSenderPool = messageSenderPool;
    }

    public MessageSenderPool<byte[], byte[]> getMessageSenderPool() {
        return this.messageSenderPool;
    }

    public MessageReceiverPool<byte[], byte[]> getMessageReceiverPool() {
        return this.messageReceiverPool;
    }

    public void setMessageReceiverPool(KafkaMessageReceiverPool<byte[], byte[]> messageReceiverPool) {
        this.messageReceiverPool = messageReceiverPool;
    }

    public void setEncoder(KafkaMessageEncoder<K, V> encoder) {
        this.encoder = encoder;
    }

    public KafkaMessageEncoder<K, V> getEncoder() {
        return this.encoder;
    }

    public KafkaMessageDecoder<K, V> getDecoder() {
        return this.decoder;
    }

    public void setDecoder(KafkaMessageDecoder<K, V> decoder) {
        this.decoder = decoder;
    }

    public void send(KafkaDestination destination, byte[] message) throws MQException {
        KafkaMessageSender<byte[], byte[]> sender = this.messageSenderPool.getSender();
        sender.send(destination.getDestinationName(), message);
        sender.close();
    }

    public void sendWithKey(KafkaDestination destination, byte[] key, byte[] message) {
        KafkaMessageSender<byte[], byte[]> sender = this.messageSenderPool.getSender();
        sender.sendWithKey(destination.getDestinationName(), key, message);
        sender.close();
    }

    public void convertAndSend(KafkaDestination destination, V message) throws MQException {
        byte[] encoded = this.encoder.encode(message);
        this.send(destination, encoded);
    }

    public void convertAndSendWithKey(KafkaDestination destination, K key, V message) throws MQException {
        byte[] encodeKey = this.encoder.encodeKey(key);
        byte[] encodeVal = this.encoder.encodeVal(message);
        this.sendWithKey(destination, encodeKey, encodeVal);
    }

    public List<byte[]> receive(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        KafkaMessageReceiver<byte[], byte[]> receiver = this.messageReceiverPool.getReceiver();
        List<byte[]> messages = receiver.receive(destination.getDestinationName(), partition, beginOffset, readOffset);
        this.messageReceiverPool.returnReceiver(receiver);
        return messages;
    }

    public Map<byte[], byte[]> receiveWithKey(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        KafkaMessageReceiver<byte[], byte[]> receiver = this.messageReceiverPool.getReceiver();
        Map<byte[], byte[]> messages = receiver.receiveWithKey(destination.getDestinationName(), partition, beginOffset, readOffset);
        this.messageReceiverPool.returnReceiver(receiver);
        return messages;
    }

    public List<V> receiveAndConvert(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        List<byte[]> decoded = this.receive(destination, partition, beginOffset, readOffset);
        return this.decoder.batchDecode(decoded);
    }

    public Map<K, V> receiveWithKeyAndConvert(KafkaDestination destination, int partition, long beginOffset, long readOffset) throws MQException {
        Map<byte[], byte[]> decoded = this.receiveWithKey(destination, partition, beginOffset, readOffset);
        return this.decoder.batchDecode(decoded);
    }
}

