/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.activemq.listener;

import java.util.concurrent.ExecutorService;
import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumerListener<T>
implements MessageListener<T> {
    protected Logger logger = LoggerFactory.getLogger(MessageConsumerListener.class);
    private Consumer<T> consumer;
    private ExecutorService threadPool;

    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer<T> consumer) {
        this.consumer = consumer;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void onMessage(final T message) throws MQException {
        if (this.consumer != null) {
            if (this.threadPool != null) {
                this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageConsumerListener.this.consumer.receive(message);
                        }
                        catch (MQException e) {
                            MessageConsumerListener.this.logger.error(e.getMessage());
                        }
                    }
                });
            } else {
                this.consumer.receive(message);
            }
        } else {
            throw new MQException("Consumer is null !");
        }
    }
}

