/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.activemq.listener;

import java.util.concurrent.ExecutorService;
import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.ConsumerFactory;
import org.darkphoenixs.mq.listener.MessageListener;
import org.darkphoenixs.mq.util.RefleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactoryConsumerListener<T>
implements MessageListener<T> {
    protected Logger logger = LoggerFactory.getLogger(MessageFactoryConsumerListener.class);
    private String consumerKeyField;
    private ConsumerFactory consumerFactory;
    private ExecutorService threadPool;

    public String getConsumerKeyField() {
        return this.consumerKeyField;
    }

    public void setConsumerKeyField(String consumerKeyField) {
        this.consumerKeyField = consumerKeyField;
    }

    public ConsumerFactory getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setConsumerFactory(ConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void onMessage(final T message) throws MQException {
        if (this.consumerFactory == null) {
            throw new MQException("ConsumerFactory is null !");
        }
        if (this.consumerKeyField == null) {
            throw new MQException("ConsumerKeyField is null !");
        }
        if (message == null) {
            throw new MQException("Message is null !");
        }
        String consumerKey = RefleTool.getFieldValue(message, this.consumerKeyField, String.class);
        if (consumerKey == null) {
            throw new MQException("Consumer Key is null !");
        }
        final Consumer<T> consumer = this.consumerFactory.getConsumer(consumerKey);
        if (consumer == null) {
            throw new MQException("Consumer is null !");
        }
        if (this.threadPool == null) {
            consumer.receive(message);
        } else {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        consumer.receive(message);
                    }
                    catch (MQException e) {
                        MessageFactoryConsumerListener.this.logger.error(e.getMessage());
                    }
                }
            });
        }
    }
}

