/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.activemq.producer;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

public abstract class AbstractProducer<T>
implements Producer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private JmsTemplate jmsTemplate;
    private Destination destination;
    private String producerKey;

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    @Override
    public void send(T message) throws MQException {
        try {
            Object obj = this.doSend(message);
            this.jmsTemplate.convertAndSend(this.destination, obj);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Send Success, ProducerKey : " + this.getProducerKey() + " , Message : " + message);
    }

    @Override
    public String getProducerKey() throws MQException {
        if (this.producerKey != null) {
            return this.producerKey;
        }
        if (this.destination instanceof Queue) {
            try {
                return ((Queue)this.destination).getQueueName();
            }
            catch (Exception e) {
                throw new MQException(e);
            }
        }
        if (this.destination instanceof Topic) {
            try {
                return ((Topic)this.destination).getTopicName();
            }
            catch (Exception e) {
                throw new MQException(e);
            }
        }
        return this.destination.toString();
    }

    public void setProducerKey(String producerKey) {
        this.producerKey = producerKey;
    }

    protected abstract Object doSend(T var1) throws MQException;
}

