/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.consumer;

import java.util.Map;
import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer<K, V>
implements Consumer<V> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String consumerKey;

    @Override
    public String getConsumerKey() throws MQException {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void receive(K key, V Val) throws MQException {
        try {
            this.doReceive(key, Val);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, ConsumerKey : " + this.getConsumerKey() + " , MessageKey : " + key + " , Message : " + Val);
    }

    @Override
    public void receive(Map<K, V> messages) throws MQException {
        try {
            this.doReceive(messages);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, Batch size : " + messages.size());
    }

    @Override
    public void receive(V message) throws MQException {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, ConsumerKey : " + this.getConsumerKey() + " , Message : " + message);
    }

    protected void doReceive(V message) throws MQException {
    }

    protected void doReceive(Map<K, V> messages) throws MQException {
    }

    protected abstract void doReceive(K var1, V var2) throws MQException;
}

