/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.darkphoenixs.kafka.core.KafkaMessageSender;

public class KafkaMessageNewSender<K, V>
implements KafkaMessageSender<K, V> {
    private static final AtomicReference<KafkaMessageNewSender<?, ?>> instance = new AtomicReference();
    private final KafkaProducer<K, V> kafkaProducer;

    private KafkaMessageNewSender(Properties properties) {
        this.kafkaProducer = new KafkaProducer(properties);
    }

    public static synchronized KafkaMessageNewSender getOrCreateInstance(Properties properties) {
        if (instance.get() == null) {
            instance.set(new KafkaMessageNewSender(properties));
        }
        return instance.get();
    }

    public List<PartitionInfo> getPartitions(String topic) {
        return this.kafkaProducer.partitionsFor(topic);
    }

    @Override
    public void send(String topic, V value) {
        this.kafkaProducer.send(new ProducerRecord(topic, value));
    }

    @Override
    public void sendWithKey(String topic, K key, V value) {
        this.kafkaProducer.send(new ProducerRecord(topic, key, value));
    }

    @Override
    public void shutDown() {
        this.kafkaProducer.flush();
        this.kafkaProducer.close();
        instance.set(null);
    }
}

