/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.pool;

import java.io.IOException;
import java.util.Properties;
import org.darkphoenixs.kafka.core.KafkaMessageNewSender;
import org.darkphoenixs.kafka.core.KafkaMessageSender;
import org.darkphoenixs.kafka.pool.MessageSenderPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class KafkaMessageNewSenderPool<K, V>
implements MessageSenderPool<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageNewSenderPool.class);
    protected Properties props = new Properties();
    protected Resource config;
    protected KafkaMessageNewSender<K, V> sender;
    protected int poolSize;

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
        try {
            PropertiesLoaderUtils.fillProperties((Properties)this.props, (Resource)this.config);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public synchronized void init() {
        logger.info("Message sender pool initializing. ");
        this.sender = KafkaMessageNewSender.getOrCreateInstance(this.props);
    }

    @Override
    public synchronized void destroy() {
        logger.info("Message sender pool closing.");
        this.sender.shutDown();
    }

    @Override
    public KafkaMessageSender<K, V> getSender() {
        KafkaMessageNewSender sender = KafkaMessageNewSender.getOrCreateInstance(this.props);
        return sender;
    }

    @Override
    public void returnSender(KafkaMessageSender<K, V> sender) {
    }
}

