/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.pool;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kafka.common.OffsetAndMetadata;
import kafka.common.TopicAndPartition;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.MessageAndMetadata;
import kafka.serializer.Decoder;
import kafka.serializer.DefaultDecoder;
import kafka.utils.VerifiableProperties;
import org.darkphoenixs.kafka.core.KafkaMessageAdapter;
import org.darkphoenixs.kafka.core.KafkaMessageReceiver;
import org.darkphoenixs.kafka.core.KafkaMessageReceiverImpl;
import org.darkphoenixs.kafka.pool.KafkaPoolThreadFactory;
import org.darkphoenixs.kafka.pool.MessageReceiverPool;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.util.RefleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class KafkaMessageReceiverPool<K, V>
implements MessageReceiverPool<K, V> {
    private static final String tagger = "KafkaMessageReceiverPool";
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageReceiverPool.class);
    protected ConsumerConnector consumer;
    protected ExecutorService pool;
    protected Properties props = new Properties();
    private KafkaMessageAdapter<?, ?> messageAdapter;
    private int poolSize;
    private Resource config;
    private int retryCount = 3;
    private Class<?> keyDecoderClass = DefaultDecoder.class;
    private Class<?> valDecoderClass = DefaultDecoder.class;
    private ThreadFactory threadFactory;

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public String getClientId() {
        return this.props.getProperty("client.id");
    }

    public void setClientId(String clientId) {
        this.props.setProperty("client.id", clientId);
    }

    public String getZookeeperStr() {
        return this.props.getProperty("zookeeper.connect");
    }

    public void setZookeeperStr(String zookeeperStr) {
        this.props.setProperty("zookeeper.connect", zookeeperStr);
    }

    public Boolean getAutoCommit() {
        return Boolean.valueOf(this.props.getProperty("auto.commit.enable", "true"));
    }

    public void setAutoCommit(boolean autoCommit) {
        this.props.setProperty("auto.commit.enable", String.valueOf(autoCommit));
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
        try {
            PropertiesLoaderUtils.fillProperties((Properties)this.props, (Resource)this.config);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public Class<?> getKeyDecoderClass() {
        return this.keyDecoderClass;
    }

    public void setKeyDecoderClass(Class<?> keyDecoderClass) {
        this.keyDecoderClass = keyDecoderClass;
    }

    public Class<?> getValDecoderClass() {
        return this.valDecoderClass;
    }

    public void setValDecoderClass(Class<?> valDecoderClass) {
        this.valDecoderClass = valDecoderClass;
    }

    public KafkaMessageAdapter<?, ?> getMessageAdapter() {
        return this.messageAdapter;
    }

    public void setMessageAdapter(KafkaMessageAdapter<?, ?> messageAdapter) {
        this.messageAdapter = messageAdapter;
    }

    @Override
    public KafkaMessageReceiver<K, V> getReceiver() {
        KafkaMessageReceiverImpl receiver = new KafkaMessageReceiverImpl(this.props, this);
        return receiver;
    }

    @Override
    public void returnReceiver(KafkaMessageReceiver<K, V> receiver) {
        if (receiver != null) {
            receiver.shutDown();
        }
    }

    @Override
    public synchronized void init() {
        String topic = this.messageAdapter.getDestination().getDestinationName();
        int defaultSize = this.getReceiver().getPartitionCount(topic);
        if (this.poolSize == 0 || this.poolSize > defaultSize) {
            this.setPoolSize(defaultSize);
        }
        this.threadFactory = new KafkaPoolThreadFactory("KafkaMessageReceiverPool-" + topic);
        this.pool = Executors.newFixedThreadPool(this.poolSize, this.threadFactory);
        logger.info("Message receiver pool initializing. poolSize : " + this.poolSize + " config : " + this.props.toString());
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)new ConsumerConfig(this.props));
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(topic, new Integer(this.poolSize));
        VerifiableProperties verProps = new VerifiableProperties(this.props);
        Decoder keyDecoder = (Decoder)RefleTool.newInstance(this.keyDecoderClass, verProps);
        Decoder valDecoder = (Decoder)RefleTool.newInstance(this.valDecoderClass, verProps);
        Map consumerMap = this.consumer.createMessageStreams(topicCountMap, keyDecoder, valDecoder);
        List streams = (List)consumerMap.get(topic);
        for (KafkaStream stream : streams) {
            this.pool.submit(new ReceiverThread(stream, this.messageAdapter));
        }
    }

    @Override
    public synchronized void destroy() {
        logger.info("Message receiver pool closing.");
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        if (this.pool != null) {
            this.pool.shutdown();
            try {
                if (!this.pool.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                    logger.warn("Timed out waiting for consumer threads to shut down, exiting uncleanly");
                }
            }
            catch (InterruptedException e) {
                logger.error("Interrupted during shutdown, exiting uncleanly");
            }
        }
    }

    class ReceiverThread
    implements Runnable {
        private KafkaStream<K, V> stream;
        private KafkaMessageAdapter<?, ?> adapter;

        public ReceiverThread(KafkaStream<K, V> stream, KafkaMessageAdapter<?, ?> adapter) {
            this.stream = stream;
            this.adapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info(Thread.currentThread().getName() + " clientId: " + this.stream.clientId() + " start.");
            ConsumerIterator it = this.stream.iterator();
            int failCount = 0;
            while (it.hasNext()) {
                MessageAndMetadata messageAndMetadata = it.next();
                try {
                    this.adapter.messageAdapter(messageAndMetadata);
                }
                catch (MQException e) {
                    logger.error(Thread.currentThread().getName() + " failCount: " + ++failCount + " topic: " + messageAndMetadata.topic() + " offset: " + messageAndMetadata.offset() + " partition: " + messageAndMetadata.partition() + " Exception: " + e.getMessage());
                }
                finally {
                    if (KafkaMessageReceiverPool.this.getAutoCommit().booleanValue() || failCount != 0 && failCount <= KafkaMessageReceiverPool.this.retryCount) continue;
                    failCount = 0;
                    KafkaMessageReceiverPool.this.consumer.commitOffsets(Collections.singletonMap(TopicAndPartition.apply((String)messageAndMetadata.topic(), (int)messageAndMetadata.partition()), OffsetAndMetadata.apply((long)(messageAndMetadata.offset() + 1L))), true);
                }
            }
            logger.info(Thread.currentThread().getName() + " clientId: " + this.stream.clientId() + " end.");
        }
    }
}

