/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.darkphoenixs.mq.consumer.Consumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.ConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumerFactory
implements ConsumerFactory {
    private static final AtomicReference<MessageConsumerFactory> instance = new AtomicReference();
    protected Logger logger = LoggerFactory.getLogger(MessageConsumerFactory.class);
    private Consumer<?>[] consumers;
    private ConcurrentHashMap<String, Consumer<?>> consumerCache = new ConcurrentHashMap();

    private MessageConsumerFactory() {
    }

    public static synchronized ConsumerFactory getInstance() {
        if (instance.get() == null) {
            instance.set(new MessageConsumerFactory());
        }
        return instance.get();
    }

    public void setConsumers(Consumer<?>[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public <T> void addConsumer(Consumer<T> consumer) throws MQException {
        this.consumerCache.put(consumer.getConsumerKey(), consumer);
        this.logger.debug("Add Consumer : " + consumer.getConsumerKey());
    }

    @Override
    public <T> Consumer<T> getConsumer(String consumerKey) throws MQException {
        if (this.consumerCache.containsKey(consumerKey)) {
            this.logger.debug("Get Consumer : " + consumerKey);
            return this.consumerCache.get(consumerKey);
        }
        this.logger.warn("Unknown ConsumerKey : " + consumerKey);
        return null;
    }

    @Override
    public void init() throws MQException {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumerCache.put(this.consumers[i].getConsumerKey(), this.consumers[i]);
            }
        }
        this.logger.debug("Initialized!");
    }

    @Override
    public void destroy() throws MQException {
        if (this.consumers != null) {
            this.consumers = null;
        }
        if (instance.get() != null) {
            instance.set(null);
        }
        this.consumerCache.clear();
        this.logger.debug("Destroyed!");
    }
}

