/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import org.dashj.platform.sdk.BaseTest;
import org.dashj.platform.sdk.BinaryData;
import org.dashj.platform.sdk.ContractBounds;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.IdentityPublicKeyV0;
import org.dashj.platform.sdk.KeyID;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.TimestampMillis;
import org.junit.Assert;
import org.junit.Test;

public class IdentityPublicKeyTest
extends BaseTest {
    @Test
    public void enumConstructorDestructorTest() {
    }

    @Test
    public void createKeyIDinJavaAndDestroy() {
        KeyID id = new KeyID(1);
        Assert.assertEquals((long)1L, (long)id.toInt());
        id.delete();
    }

    @Test
    public void createTimestampMillisinJavaAndDestroy() {
        long timestamp = System.currentTimeMillis();
        TimestampMillis ts = new TimestampMillis(timestamp);
        Assert.assertEquals((long)timestamp, (long)ts.toLong());
        ts.delete();
    }

    @Test
    public void createTimestampMillisinJavaAndDestroy2() {
        long timestamp = System.currentTimeMillis();
        TimestampMillis ts = new TimestampMillis();
        Assert.assertEquals((long)(timestamp / 1000L), (long)(ts.toLong() / 1000L));
        ts.delete();
    }

    @Test
    public void enumTest() {
        Purpose purpose = Purpose.AUTHENTICATION;
        KeyType keyType = KeyType.ECDSA_SECP256K1;
        SecurityLevel securityLevel = SecurityLevel.HIGH;
        Assert.assertEquals((Object)KeyType.ECDSA_SECP256K1, (Object)keyType);
        Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)purpose);
        Assert.assertEquals((Object)SecurityLevel.HIGH, (Object)securityLevel);
    }

    @Test
    public void createIdentityPublicKeyInJavaAndDestroyWithNullsTest() {
        KeyID keyId = new KeyID(2);
        Purpose purpose = Purpose.AUTHENTICATION;
        KeyType keyType = KeyType.ECDSA_SECP256K1;
        SecurityLevel securityLevel = SecurityLevel.HIGH;
        BinaryData data = new BinaryData(publicKey);
        Assert.assertArrayEquals((byte[])publicKey, (byte[])data.get_0());
        IdentityPublicKeyV0 ipkv0 = new IdentityPublicKeyV0(keyId, purpose, securityLevel, null, keyType, false, data, null);
        System.out.printf("identitypublickeyv0 %x\n", IdentityPublicKeyV0.getCPtr((IdentityPublicKeyV0)ipkv0));
        System.out.flush();
        Assert.assertEquals((long)2L, (long)ipkv0.getId().toInt());
        Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)ipkv0.getPurpose());
        Assert.assertEquals((Object)KeyType.ECDSA_SECP256K1, (Object)ipkv0.getKeyType());
        Assert.assertEquals((Object)SecurityLevel.HIGH, (Object)ipkv0.getSecurityLevel());
        Assert.assertArrayEquals((byte[])publicKey, (byte[])ipkv0.getData().get_0());
        Assert.assertFalse((boolean)ipkv0.getRead_only());
        Assert.assertNull((Object)ipkv0.getDisabled_at());
        Assert.assertNull((Object)ipkv0.getContract_bounds());
        ipkv0.delete();
        data.delete();
        keyId.delete();
    }

    @Test
    public void createIdentityPublicKeyInJavaAndDestroyTest() {
        KeyID keyId = new KeyID(0);
        Purpose purpose = Purpose.AUTHENTICATION;
        KeyType keyType = KeyType.ECDSA_SECP256K1;
        SecurityLevel securityLevel = SecurityLevel.HIGH;
        BinaryData data = new BinaryData(publicKey);
        Identifier id = new Identifier(contractIdentifier);
        ContractBounds singleContract = new ContractBounds(id);
        TimestampMillis timestampMillis = new TimestampMillis();
        Assert.assertArrayEquals((byte[])publicKey, (byte[])data.get_0());
        IdentityPublicKeyV0 ipkv0 = new IdentityPublicKeyV0(keyId, purpose, securityLevel, singleContract, keyType, false, data, timestampMillis);
        Assert.assertEquals((Object)purpose, (Object)ipkv0.getPurpose());
        Assert.assertEquals((Object)keyType, (Object)ipkv0.getKeyType());
        Assert.assertEquals((Object)securityLevel, (Object)ipkv0.getSecurityLevel());
        Assert.assertEquals((long)keyId.toInt(), (long)ipkv0.getId().toInt());
        Assert.assertArrayEquals((byte[])publicKey, (byte[])ipkv0.getData().get_0());
        Assert.assertEquals((Object)timestampMillis, (Object)ipkv0.getDisabled_at());
        Assert.assertEquals((Object)singleContract.getTag(), (Object)ipkv0.getContract_bounds().getTag());
        Assert.assertEquals((Object)singleContract.getSingle_contract().getId(), (Object)ipkv0.getContract_bounds().getSingle_contract().getId());
        Assert.assertFalse((boolean)ipkv0.getRead_only());
        System.out.printf("ipkv0 0x%016x\n", IdentityPublicKeyV0.getCPtr((IdentityPublicKeyV0)ipkv0));
        System.out.flush();
        ContractBounds singleContractDocumentType = new ContractBounds(id, "type");
        IdentityPublicKeyV0 ipkv0a = new IdentityPublicKeyV0(keyId, purpose, securityLevel, singleContractDocumentType, keyType, false, data, timestampMillis);
        Assert.assertEquals((Object)singleContractDocumentType.getTag(), (Object)ipkv0a.getContract_bounds().getTag());
        Assert.assertEquals((Object)singleContractDocumentType.getSingle_contract_document_type().getDocument_type_name(), (Object)ipkv0a.getContract_bounds().getSingle_contract_document_type().getDocument_type_name());
        Assert.assertEquals((Object)singleContractDocumentType.getSingle_contract_document_type().getId(), (Object)ipkv0a.getContract_bounds().getSingle_contract_document_type().getId());
        ipkv0.delete();
        ipkv0a.delete();
        data.delete();
        singleContractDocumentType.delete();
        singleContract.delete();
        timestampMillis.delete();
        keyId.delete();
        id.delete();
        ipkv0 = null;
    }
}

